/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TransactionOptions {
    private static final int DEFAULT_NUM_ATTEMPTS = 5;
    private final int numberOfAttempts;
    private final Executor executor;
    private final ByteString previousTransactionId;

    TransactionOptions(int maxAttempts, Executor executor, ByteString previousTransactionId) {
        this.numberOfAttempts = maxAttempts;
        this.executor = executor;
        this.previousTransactionId = previousTransactionId;
    }

    public int getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    @Nullable
    ByteString getPreviousTransactionId() {
        return this.previousTransactionId;
    }

    @Nonnull
    public static TransactionOptions create() {
        return new TransactionOptions(5, null, null);
    }

    @Nonnull
    public static TransactionOptions create(int numberOfAttempts) {
        Preconditions.checkArgument((numberOfAttempts > 0 ? 1 : 0) != 0, (Object)"You must allow at least one attempt");
        return new TransactionOptions(numberOfAttempts, null, null);
    }

    @Nonnull
    public static TransactionOptions create(@Nonnull Executor executor) {
        return new TransactionOptions(5, executor, null);
    }

    @Nonnull
    public static TransactionOptions create(@Nonnull Executor executor, int numberOfAttempts) {
        Preconditions.checkArgument((numberOfAttempts > 0 ? 1 : 0) != 0, (Object)"You must allow at least one attempt");
        return new TransactionOptions(numberOfAttempts, executor, null);
    }
}

