/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.BasePath;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.DocumentTransform;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.Write;
import com.google.protobuf.ByteString;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class UpdateBuilder<T extends UpdateBuilder> {
    final FirestoreImpl firestore;
    private final List<Mutation> mutations;
    private boolean committed;

    UpdateBuilder(FirestoreImpl firestore) {
        this.firestore = firestore;
        this.mutations = new ArrayList<Mutation>();
    }

    private static Map<String, Object> expandObject(Map<FieldPath, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TreeSet<FieldPath> sortedFields = new TreeSet<FieldPath>(data.keySet());
        BasePath lastField = null;
        for (FieldPath field : sortedFields) {
            if (lastField != null && lastField.isPrefixOf(field)) {
                throw new IllegalArgumentException(String.format("Detected ambiguous definition for field '%s'.", lastField));
            }
            ImmutableList<String> segments = field.getSegments();
            Object value = data.get(field);
            Map<String, Object> currentMap = result;
            for (int i = 0; i < segments.size(); ++i) {
                if (i == segments.size() - 1) {
                    currentMap.put((String)segments.get(i), value);
                    continue;
                }
                if (!currentMap.containsKey(segments.get(i))) {
                    currentMap.put((String)segments.get(i), new HashMap());
                }
                currentMap = (Map)currentMap.get(segments.get(i));
            }
            lastField = field;
        }
        return result;
    }

    @Nonnull
    public T create(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.performCreate(documentReference, fields);
    }

    private T performCreate(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, fields, UserDataConverter.NO_DELETES);
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(documentReference, this.convertToFieldPaths(fields, false));
        Mutation mutation = this.addMutation();
        mutation.precondition = Precondition.exists(false).toPb();
        if (!documentSnapshot.isEmpty() || documentTransform.isEmpty()) {
            mutation.document = documentSnapshot.toPb();
        }
        if (!documentTransform.isEmpty()) {
            mutation.transform = documentTransform.toPb();
        }
        return (T)this;
    }

    private Mutation addMutation() {
        Preconditions.checkState((!this.committed ? 1 : 0) != 0, (Object)"Cannot modify a WriteBatch that has already been committed.");
        Mutation mutation = new Mutation();
        this.mutations.add(mutation);
        return mutation;
    }

    @Nonnull
    public T create(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(data instanceof Map)) {
            FirestoreException.invalidState("Can't set a document's data to an array or primitive", new Object[0]);
        }
        return this.performCreate(documentReference, (Map)data);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.set(documentReference, fields, SetOptions.OVERWRITE);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        return this.performSet(documentReference, fields, options);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        return this.set(documentReference, pojo, SetOptions.OVERWRITE);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo, @Nonnull SetOptions options) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("Can't set a document's data to an array or primitive");
        }
        return this.performSet(documentReference, (Map)data, options);
    }

    private T performSet(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        boolean hasDocumentData;
        Map<FieldPath, Object> documentData = options.getFieldMask() != null ? this.applyFieldMask(fields, options.getFieldMask()) : this.convertToFieldPaths(fields, false);
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, UpdateBuilder.expandObject(documentData), options.getEncodingOptions());
        FieldMask documentMask = FieldMask.EMPTY_MASK;
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(documentReference, documentData);
        if (options.isMerge()) {
            if (options.getFieldMask() != null) {
                ArrayList<FieldPath> fieldMask = new ArrayList<FieldPath>(options.getFieldMask());
                fieldMask.removeAll(documentTransform.getFields());
                documentMask = new FieldMask(fieldMask);
            } else {
                documentMask = FieldMask.fromObject(fields);
            }
        }
        Mutation mutation = this.addMutation();
        boolean bl = hasDocumentData = !documentSnapshot.isEmpty() || !documentMask.isEmpty();
        if (!options.isMerge()) {
            mutation.document = documentSnapshot.toPb();
        } else if (hasDocumentData || documentTransform.isEmpty()) {
            mutation.document = documentSnapshot.toPb();
            mutation.document.setUpdateMask(documentMask.toPb());
        }
        if (!documentTransform.isEmpty()) {
            mutation.transform = documentTransform.toPb();
        }
        return (T)this;
    }

    private Map<FieldPath, Object> applyFieldMask(Map<String, Object> fields, List<FieldPath> fieldMask) {
        ArrayList<FieldPath> remainingFields = new ArrayList<FieldPath>(fieldMask);
        Map<FieldPath, Object> filteredData = this.applyFieldMask(fields, remainingFields, FieldPath.empty());
        if (!remainingFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("Field masks contains invalid path. No data exist at field '%s'.", remainingFields.get(0)));
        }
        return filteredData;
    }

    private Map<FieldPath, Object> applyFieldMask(Map<String, Object> fields, List<FieldPath> fieldMask, FieldPath root) {
        HashMap<FieldPath, Object> filteredMap = new HashMap<FieldPath, Object>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            FieldPath currentField = root.append(FieldPath.of(entry.getKey()));
            if (fieldMask.remove(currentField)) {
                filteredMap.put(currentField, entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                filteredMap.putAll(this.applyFieldMask((Map)entry.getValue(), fieldMask, currentField));
                continue;
            }
            if (entry.getValue() != FieldValue.DELETE_SENTINEL) continue;
            throw new IllegalArgumentException(String.format("Cannot specify FieldValue.delete() for non-merged field '%s'.", currentField));
        }
        return filteredMap;
    }

    private Map<FieldPath, Object> convertToFieldPaths(@Nonnull Map<String, Object> fields, boolean splitOnDots) {
        HashMap<FieldPath, Object> fieldPaths = new HashMap<FieldPath, Object>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            if (splitOnDots) {
                fieldPaths.put(FieldPath.fromDotSeparatedString(entry.getKey()), entry.getValue());
                continue;
            }
            fieldPaths.put(FieldPath.of(entry.getKey()), entry.getValue());
        }
        return fieldPaths;
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.performUpdate(documentReference, this.convertToFieldPaths(fields, true), Precondition.exists(true));
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, Precondition options) {
        Preconditions.checkArgument((!options.hasExists() ? 1 : 0) != 0, (Object)"Precondition 'exists' cannot be specified for update() calls.");
        return this.performUpdate(documentReference, this.convertToFieldPaths(fields, true), options);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.performUpdate(documentReference, Precondition.exists(true), FieldPath.fromDotSeparatedString(field), value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.performUpdate(documentReference, Precondition.exists(true), fieldPath, value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Precondition options, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        Preconditions.checkArgument((!options.hasExists() ? 1 : 0) != 0, (Object)"Precondition 'exists' cannot be specified for update() calls.");
        return this.performUpdate(documentReference, options, FieldPath.fromDotSeparatedString(field), value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Precondition options, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        Preconditions.checkArgument((!options.hasExists() ? 1 : 0) != 0, (Object)"Precondition 'exists' cannot be specified for update() calls.");
        return this.performUpdate(documentReference, options, fieldPath, value, moreFieldsAndValues);
    }

    private T performUpdate(@Nonnull DocumentReference documentReference, @Nonnull Precondition options, @Nonnull FieldPath fieldPath, @Nullable Object value, Object[] moreFieldsAndValues) {
        HashMap<FieldPath, Object> fields = new HashMap<FieldPath, Object>();
        fields.put(fieldPath, value);
        Preconditions.checkArgument((moreFieldsAndValues.length % 2 == 0 ? 1 : 0) != 0, (Object)"moreFieldsAndValues must be key-value pairs.");
        for (int i = 0; i < moreFieldsAndValues.length; i += 2) {
            FieldPath currentPath;
            Object objectPath = moreFieldsAndValues[i];
            Object objectValue = moreFieldsAndValues[i + 1];
            if (objectPath instanceof String) {
                currentPath = FieldPath.fromDotSeparatedString((String)objectPath);
            } else if (objectPath instanceof FieldPath) {
                currentPath = (FieldPath)objectPath;
            } else {
                throw new IllegalArgumentException("Field '" + objectPath + "' is not of type String or Field Path.");
            }
            if (fields.containsKey(currentPath)) {
                throw new IllegalArgumentException("Field value for field '" + objectPath + "' was specified multiple times.");
            }
            fields.put(currentPath, objectValue);
        }
        return this.performUpdate(documentReference, fields, options);
    }

    private T performUpdate(@Nonnull DocumentReference documentReference, final @Nonnull Map<FieldPath, Object> fields, @Nonnull Precondition precondition) {
        Preconditions.checkArgument((!fields.isEmpty() ? 1 : 0) != 0, (Object)"Data for update() cannot be empty.");
        Map<String, Object> deconstructedMap = UpdateBuilder.expandObject(fields);
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, deconstructedMap, new UserDataConverter.EncodingOptions(){

            @Override
            public boolean allowDelete(FieldPath fieldPath) {
                return fields.containsKey(fieldPath);
            }

            @Override
            public boolean allowTransform() {
                return true;
            }
        });
        ArrayList<FieldPath> fieldPaths = new ArrayList<FieldPath>(fields.keySet());
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(documentReference, fields);
        fieldPaths.removeAll(documentTransform.getFields());
        FieldMask fieldMask = new FieldMask(fieldPaths);
        Mutation mutation = this.addMutation();
        mutation.precondition = precondition.toPb();
        if (!documentSnapshot.isEmpty() || !fieldMask.isEmpty()) {
            mutation.document = documentSnapshot.toPb();
            mutation.document.setUpdateMask(fieldMask.toPb());
        }
        if (!documentTransform.isEmpty()) {
            mutation.transform = documentTransform.toPb();
        }
        return (T)this;
    }

    @Nonnull
    public T delete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        return this.performDelete(documentReference, precondition);
    }

    @Nonnull
    public T delete(@Nonnull DocumentReference documentReference) {
        return this.performDelete(documentReference, Precondition.NONE);
    }

    private T performDelete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        Mutation mutation = this.addMutation();
        mutation.document = Write.newBuilder().setDelete(documentReference.getName());
        if (!precondition.isEmpty()) {
            mutation.precondition = precondition.toPb();
        }
        return (T)this;
    }

    ApiFuture<List<WriteResult>> commit(@Nullable ByteString transactionId) {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestore.Commit", (Map)ImmutableMap.of((Object)"numDocuments", (Object)AttributeValue.longAttributeValue((long)this.mutations.size())));
        final CommitRequest.Builder request = CommitRequest.newBuilder();
        request.setDatabase(this.firestore.getDatabaseName());
        for (Mutation mutation : this.mutations) {
            Preconditions.checkState((mutation.document != null || mutation.transform != null ? 1 : 0) != 0, (Object)"Either a write or transform must be set");
            if (mutation.precondition != null) {
                (mutation.document != null ? mutation.document : mutation.transform).setCurrentDocument(mutation.precondition);
            }
            if (mutation.document != null) {
                request.addWrites(mutation.document);
            }
            if (mutation.transform == null) continue;
            request.addWrites(mutation.transform);
        }
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        this.committed = true;
        ApiFuture<CommitResponse> response = this.firestore.sendRequest(request.build(), this.firestore.getClient().commitCallable());
        return ApiFutures.transform(response, (ApiFunction)new ApiFunction<CommitResponse, List<WriteResult>>(){

            public List<WriteResult> apply(CommitResponse commitResponse) {
                List writeResults = commitResponse.getWriteResultsList();
                ArrayList<WriteResult> result = new ArrayList<WriteResult>();
                Preconditions.checkState((request.getWritesCount() == writeResults.size() ? 1 : 0) != 0, (String)"Expected one write result per operation, but got %s results for %s operations.", (int)writeResults.size(), (int)request.getWritesCount());
                Iterator mutationIterator = UpdateBuilder.this.mutations.iterator();
                Iterator responseIterator = writeResults.iterator();
                while (mutationIterator.hasNext()) {
                    Mutation mutation = (Mutation)mutationIterator.next();
                    if (mutation.document != null && mutation.transform != null) {
                        responseIterator.next();
                    }
                    result.add(WriteResult.fromProto((com.google.firestore.v1.WriteResult)responseIterator.next(), commitResponse.getCommitTime()));
                }
                return result;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    boolean isEmpty() {
        return this.mutations.isEmpty();
    }

    public int getMutationsSize() {
        return this.mutations.size();
    }

    private static class Mutation {
        Write.Builder document;
        Write.Builder transform;
        com.google.firestore.v1.Precondition precondition;

        private Mutation() {
        }
    }
}

