/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Key;
import java.io.IOException;

public final class FirebaseCustomAuthToken
extends IdToken {
    static final String FIREBASE_AUDIENCE = "https://identitytoolkit.googleapis.com/google.identity.identitytoolkit.v1.IdentityToolkit";
    static final long TOKEN_DURATION_SECONDS = 3600L;

    public FirebaseCustomAuthToken(JsonWebSignature.Header header, Payload payload, byte[] signatureBytes, byte[] signedContentBytes) {
        super(header, (IdToken.Payload)payload, signatureBytes, signedContentBytes);
    }

    public static FirebaseCustomAuthToken parse(JsonFactory jsonFactory, String tokenString) throws IOException {
        JsonWebSignature jws = JsonWebSignature.parser((JsonFactory)jsonFactory).setPayloadClass(Payload.class).parse(tokenString);
        return new FirebaseCustomAuthToken(jws.getHeader(), (Payload)jws.getPayload(), jws.getSignatureBytes(), jws.getSignedContentBytes());
    }

    public Payload getPayload() {
        return (Payload)super.getPayload();
    }

    public static class Payload
    extends IdToken.Payload {
        @Key(value="uid")
        private String uid;
        @Key(value="claims")
        private GenericJson developerClaims;

        public final String getUid() {
            return this.uid;
        }

        public Payload setUid(String uid) {
            this.uid = uid;
            return this;
        }

        public final GenericJson getDeveloperClaims() {
            return this.developerClaims;
        }

        public Payload setDeveloperClaims(GenericJson developerClaims) {
            this.developerClaims = developerClaims;
            return this;
        }

        public Payload setIssuer(String issuer) {
            return (Payload)super.setIssuer(issuer);
        }

        public Payload setSubject(String subject) {
            return (Payload)super.setSubject(subject);
        }

        public Payload setAudience(Object audience) {
            return (Payload)super.setAudience(audience);
        }

        public Payload setIssuedAtTimeSeconds(Long issuedAt) {
            return (Payload)super.setIssuedAtTimeSeconds(issuedAt);
        }

        public Payload setExpirationTimeSeconds(Long expirationTime) {
            return (Payload)super.setExpirationTimeSeconds(expirationTime);
        }
    }
}

