/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache;

import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.oak.cache.AbstractCacheStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheStats
extends AbstractCacheStats {
    private final Cache<Object, Object> cache;
    private final Weigher<Object, Object> weigher;
    private final long maxWeight;

    public CacheStats(@NotNull Cache<?, ?> cache, @NotNull String name, @Nullable Weigher<?, ?> weigher, long maxWeight) {
        super(name);
        this.cache = Objects.requireNonNull(cache);
        this.weigher = weigher;
        this.maxWeight = maxWeight;
    }

    @Override
    protected org.apache.jackrabbit.guava.common.cache.CacheStats getCurrentStats() {
        return this.cache.stats();
    }

    public long getElementCount() {
        return this.cache.size();
    }

    public long estimateCurrentWeight() {
        if (this.weigher == null) {
            return -1L;
        }
        long size = 0L;
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            size += (long)this.weigher.weigh(k, v);
        }
        return size;
    }

    public long getMaxTotalWeight() {
        return this.maxWeight;
    }
}

