/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.util.BiStatsConsumer;
import org.apache.jackrabbit.oak.plugins.document.util.TriStatsConsumer;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;

public class StatsCollectorUtil {
    private StatsCollectorUtil() {
    }

    public static void perfLog(Logger perfLog, int perfLogThreshold, long timeTakenNanos, String logMsgPrefix, Object ... arguments) {
        if (!perfLog.isDebugEnabled()) {
            return;
        }
        long diff = TimeUnit.NANOSECONDS.toMillis(timeTakenNanos);
        if (perfLog.isTraceEnabled()) {
            perfLog.trace(logMsgPrefix + " [took " + diff + "ms]", arguments);
        } else if (diff > (long)perfLogThreshold) {
            perfLog.debug(logMsgPrefix + " [took " + diff + "ms]", arguments);
        }
    }

    public static BiStatsConsumer getStatsConsumer() {
        return (cJ, cJT, count, tTN) -> {
            cJ.mark(count);
            cJT.update(tTN / count, TimeUnit.NANOSECONDS);
        };
    }

    public static BiStatsConsumer getJournalStatsConsumer() {
        return (cJ, cJT, count, tTN) -> {
            cJ.mark(count);
            cJT.update(tTN, TimeUnit.NANOSECONDS);
        };
    }

    public static TriStatsConsumer getCreateStatsConsumer() {
        return (cNUM, cSNM, cNUT, ids1, tTN) -> {
            for (String id : ids1) {
                cNUM.mark();
                if (!Utils.isPreviousDocId(id)) continue;
                cSNM.mark();
            }
            cNUT.update(tTN / (long)ids1.size(), TimeUnit.NANOSECONDS);
        };
    }

    public static BiPredicate<Collection<? extends Document>, Integer> isNodesCollectionUpdated() {
        return (c, i) -> c == Collection.NODES && i > 0;
    }
}

