/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import java.io.InputStream;
import java.util.Optional;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.file.proc.JournalNode;
import org.apache.jackrabbit.oak.segment.file.proc.StoreNode;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class Proc {
    public static NodeState of(Backend backend) {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.setChildNode("store", (NodeState)new StoreNode(backend));
        builder.setChildNode("journal", (NodeState)new JournalNode(backend));
        return builder.getNodeState();
    }

    private Proc() {
    }

    public static interface Backend {
        public boolean tarExists(String var1);

        public Optional<Long> getTarSize(String var1);

        public Iterable<String> getTarNames();

        public boolean segmentExists(String var1, String var2);

        public Iterable<String> getSegmentIds(String var1);

        public Optional<Segment> getSegment(String var1);

        public Optional<InputStream> getSegmentData(String var1);

        public Optional<Iterable<String>> getSegmentReferences(String var1);

        public Optional<Iterable<Record>> getSegmentRecords(String var1);

        public boolean commitExists(String var1);

        public Iterable<String> getCommitHandles();

        public Optional<Commit> getCommit(String var1);

        public static interface Record {
            public int getNumber();

            public String getSegmentId();

            public int getOffset();

            public int getAddress();

            public String getType();

            public Optional<NodeState> getRoot();
        }

        public static interface Commit {
            public long getTimestamp();

            public String getRevision();

            public Optional<NodeState> getRoot();
        }

        public static interface Segment {
            public int getGeneration();

            public int getFullGeneration();

            public boolean isCompacted();

            public int getLength();

            public int getVersion();

            public boolean isDataSegment();

            public Optional<String> getInfo();
        }
    }
}

