/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.MultiBinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.CancelableDiff;
import org.apache.jackrabbit.oak.segment.Compactor;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.gradle.internal.classpath.Instrumented;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassicCompactor
implements Compactor {
    static final int UPDATE_LIMIT = Instrumented.getInteger((String)"compaction.update.limit", (int)10000, (String)"org.apache.jackrabbit.oak.segment.ClassicCompactor");
    @NotNull
    private final SegmentWriter writer;
    @NotNull
    private final SegmentReader reader;
    @Nullable
    private final BlobStore blobStore;
    @NotNull
    private final GCNodeWriteMonitor compactionMonitor;

    public ClassicCompactor(@NotNull SegmentReader reader, @NotNull SegmentWriter writer, @Nullable BlobStore blobStore, @NotNull GCNodeWriteMonitor compactionMonitor) {
        this.writer = (SegmentWriter)Preconditions.checkNotNull((Object)writer);
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.blobStore = blobStore;
        this.compactionMonitor = (GCNodeWriteMonitor)Preconditions.checkNotNull((Object)compactionMonitor);
    }

    @Nullable
    public SegmentNodeState compact(@NotNull NodeState state, Canceller canceller) throws IOException {
        return this.compact(EmptyNodeState.EMPTY_NODE, state, EmptyNodeState.EMPTY_NODE, canceller);
    }

    @Override
    @Nullable
    public SegmentNodeState compact(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, Canceller canceller) throws IOException {
        Preconditions.checkNotNull((Object)before);
        Preconditions.checkNotNull((Object)after);
        Preconditions.checkNotNull((Object)onto);
        return new CompactDiff(onto, canceller).diff(before, after);
    }

    @Nullable
    private static Buffer getStableIdBytes(NodeState state) {
        if (state instanceof SegmentNodeState) {
            return ((SegmentNodeState)state).getStableIdBytes();
        }
        return null;
    }

    @NotNull
    private PropertyState compact(@NotNull PropertyState property) {
        this.compactionMonitor.onProperty();
        String name = property.getName();
        Type type = property.getType();
        if (type == Type.BINARY) {
            this.compactionMonitor.onBinary();
            return BinaryPropertyState.binaryProperty((String)name, (Blob)((Blob)property.getValue(Type.BINARY)));
        }
        if (type == Type.BINARIES) {
            ArrayList blobs = Lists.newArrayList();
            for (Blob blob : (Iterable)property.getValue(Type.BINARIES)) {
                this.compactionMonitor.onBinary();
                blobs.add(blob);
            }
            return MultiBinaryPropertyState.binaryPropertyFromBlob((String)name, (Iterable)blobs);
        }
        return PropertyStates.createProperty((String)name, (Object)property.getValue(type), (Type)type);
    }

    private class CompactDiff
    implements NodeStateDiff {
        @NotNull
        private MemoryNodeBuilder builder;
        @NotNull
        private final NodeState base;
        private final Canceller canceller;
        @Nullable
        private IOException exception;
        private long modCount;

        private void updated() throws IOException {
            if (++this.modCount % (long)UPDATE_LIMIT == 0L) {
                RecordId newBaseId = ClassicCompactor.this.writer.writeNode(this.builder.getNodeState(), null);
                SegmentNodeState newBase = new SegmentNodeState(ClassicCompactor.this.reader, ClassicCompactor.this.writer, ClassicCompactor.this.blobStore, newBaseId);
                this.builder = new MemoryNodeBuilder((NodeState)newBase);
            }
        }

        CompactDiff(NodeState base, Canceller canceller) {
            this.builder = new MemoryNodeBuilder((NodeState)Preconditions.checkNotNull((Object)base));
            this.canceller = canceller;
            this.base = base;
        }

        @Nullable
        SegmentNodeState diff(@NotNull NodeState before, @NotNull NodeState after) throws IOException {
            boolean success = after.compareAgainstBaseState(before, (NodeStateDiff)new CancelableDiff(this, (Supplier<Boolean>)((Supplier)() -> this.canceller.check().isCancelled())));
            if (this.exception != null) {
                throw new IOException(this.exception);
            }
            if (success) {
                NodeState nodeState = this.builder.getNodeState();
                Preconditions.checkState((this.modCount == 0L || !(nodeState instanceof SegmentNodeState) ? 1 : 0) != 0);
                RecordId nodeId = ClassicCompactor.this.writer.writeNode(nodeState, ClassicCompactor.getStableIdBytes(after));
                ClassicCompactor.this.compactionMonitor.onNode();
                return new SegmentNodeState(ClassicCompactor.this.reader, ClassicCompactor.this.writer, ClassicCompactor.this.blobStore, nodeId);
            }
            return null;
        }

        public boolean propertyAdded(@NotNull PropertyState after) {
            this.builder.setProperty(ClassicCompactor.this.compact(after));
            return true;
        }

        public boolean propertyChanged(@NotNull PropertyState before, @NotNull PropertyState after) {
            this.builder.setProperty(ClassicCompactor.this.compact(after));
            return true;
        }

        public boolean propertyDeleted(PropertyState before) {
            this.builder.removeProperty(before.getName());
            return true;
        }

        public boolean childNodeAdded(@NotNull String name, @NotNull NodeState after) {
            try {
                SegmentNodeState compacted = ClassicCompactor.this.compact(after, this.canceller);
                if (compacted != null) {
                    this.updated();
                    this.builder.setChildNode(name, (NodeState)compacted);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
        }

        public boolean childNodeChanged(@NotNull String name, @NotNull NodeState before, @NotNull NodeState after) {
            try {
                SegmentNodeState compacted = ClassicCompactor.this.compact(before, after, this.base.getChildNode(name), this.canceller);
                if (compacted != null) {
                    this.updated();
                    this.builder.setChildNode(name, (NodeState)compacted);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            try {
                this.updated();
                this.builder.getChildNode(name).remove();
                return true;
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
        }
    }
}

