/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security;

import java.util.HashSet;
import java.util.Map;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.impl.RootProviderService;
import org.apache.jackrabbit.oak.plugins.tree.impl.TreeProviderService;
import org.apache.jackrabbit.oak.security.authentication.AuthenticationConfigurationImpl;
import org.apache.jackrabbit.oak.security.authentication.token.TokenConfigurationImpl;
import org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.authorization.restriction.WhiteboardRestrictionProvider;
import org.apache.jackrabbit.oak.security.principal.PrincipalConfigurationImpl;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeConfigurationImpl;
import org.apache.jackrabbit.oak.security.user.UserConfigurationImpl;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardAuthorizableActionProvider;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardAuthorizableNodeName;
import org.apache.jackrabbit.oak.security.user.whiteboard.WhiteboardUserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.CompositeTokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.CompositePrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;

@Deprecated
public class SecurityProviderImpl
implements SecurityProvider,
WhiteboardAware {
    private volatile AuthenticationConfiguration authenticationConfiguration;
    private volatile PrivilegeConfiguration privilegeConfiguration;
    private volatile UserConfiguration userConfiguration;
    private final CompositeAuthorizationConfiguration authorizationConfiguration = new CompositeAuthorizationConfiguration(this);
    private final CompositePrincipalConfiguration principalConfiguration = new CompositePrincipalConfiguration((SecurityProvider)this);
    private final CompositeTokenConfiguration tokenConfiguration = new CompositeTokenConfiguration((SecurityProvider)this);
    private final WhiteboardAuthorizableNodeName authorizableNodeName = new WhiteboardAuthorizableNodeName();
    private final WhiteboardAuthorizableActionProvider authorizableActionProvider = new WhiteboardAuthorizableActionProvider();
    private final WhiteboardRestrictionProvider restrictionProvider = new WhiteboardRestrictionProvider();
    private final WhiteboardUserAuthenticationFactory userAuthenticationFactory = new WhiteboardUserAuthenticationFactory(UserConfigurationImpl.getDefaultAuthenticationFactory());
    private ConfigurationParameters configuration;
    private Whiteboard whiteboard;
    private final RootProvider rootProvider = new RootProviderService();
    private final TreeProvider treeProvider = new TreeProviderService();

    public SecurityProviderImpl() {
        this(ConfigurationParameters.EMPTY);
    }

    public SecurityProviderImpl(@NotNull ConfigurationParameters configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configuration = configuration;
        this.authenticationConfiguration = this.initDefaultConfiguration(new AuthenticationConfigurationImpl(this));
        this.userConfiguration = this.initDefaultConfiguration(new UserConfigurationImpl(this));
        this.privilegeConfiguration = this.initDefaultConfiguration(new PrivilegeConfigurationImpl());
        this.initCompositeConfiguration(this.authorizationConfiguration, (SecurityConfiguration)new AuthorizationConfigurationImpl(this));
        this.initCompositeConfiguration((CompositeConfiguration)this.principalConfiguration, (SecurityConfiguration)new PrincipalConfigurationImpl(this));
        this.initCompositeConfiguration((CompositeConfiguration)this.tokenConfiguration, (SecurityConfiguration)new TokenConfigurationImpl(this));
    }

    public void setWhiteboard(@NotNull Whiteboard whiteboard) {
        this.whiteboard = whiteboard;
    }

    @Nullable
    public Whiteboard getWhiteboard() {
        return this.whiteboard;
    }

    @NotNull
    public ConfigurationParameters getParameters(@Nullable String name) {
        if (name == null) {
            return this.configuration;
        }
        ConfigurationParameters params = (ConfigurationParameters)this.configuration.getConfigValue(name, (Object)ConfigurationParameters.EMPTY);
        for (SecurityConfiguration securityConfiguration : this.getConfigurations()) {
            if (securityConfiguration == null || !securityConfiguration.getName().equals(name)) continue;
            return ConfigurationParameters.of((ConfigurationParameters[])new ConfigurationParameters[]{params, securityConfiguration.getParameters()});
        }
        return params;
    }

    @NotNull
    public Iterable<? extends SecurityConfiguration> getConfigurations() {
        HashSet<Object> scs = new HashSet<Object>();
        scs.add(this.authenticationConfiguration);
        scs.add((Object)this.authorizationConfiguration);
        scs.add(this.userConfiguration);
        scs.add(this.principalConfiguration);
        scs.add(this.privilegeConfiguration);
        scs.add(this.tokenConfiguration);
        return scs;
    }

    @NotNull
    public <T> T getConfiguration(@NotNull Class<T> configClass) {
        if (AuthenticationConfiguration.class == configClass) {
            return (T)this.authenticationConfiguration;
        }
        if (AuthorizationConfiguration.class == configClass) {
            return (T)((Object)this.authorizationConfiguration);
        }
        if (UserConfiguration.class == configClass) {
            return (T)this.userConfiguration;
        }
        if (PrincipalConfiguration.class == configClass) {
            return (T)this.principalConfiguration;
        }
        if (PrivilegeConfiguration.class == configClass) {
            return (T)this.privilegeConfiguration;
        }
        if (TokenConfiguration.class == configClass) {
            return (T)this.tokenConfiguration;
        }
        throw new IllegalArgumentException("Unsupported security configuration class " + configClass);
    }

    protected void activate(BundleContext context) {
        this.whiteboard = new OsgiWhiteboard(context);
        this.authorizableActionProvider.start(this.whiteboard);
        this.authorizableNodeName.start(this.whiteboard);
        this.restrictionProvider.start(this.whiteboard);
        this.userAuthenticationFactory.start(this.whiteboard);
        this.initializeConfigurations();
    }

    protected void deactivate() {
        this.authorizableActionProvider.stop();
        this.authorizableNodeName.stop();
        this.restrictionProvider.stop();
        this.userAuthenticationFactory.stop();
    }

    protected void bindPrincipalConfiguration(@NotNull PrincipalConfiguration reference) {
        this.principalConfiguration.addConfiguration((SecurityConfiguration)this.initConfiguration(reference));
    }

    protected void unbindPrincipalConfiguration(@NotNull PrincipalConfiguration reference) {
        this.principalConfiguration.removeConfiguration((SecurityConfiguration)reference);
    }

    protected void bindTokenConfiguration(@NotNull TokenConfiguration reference) {
        this.tokenConfiguration.addConfiguration((SecurityConfiguration)this.initConfiguration(reference));
    }

    protected void unbindTokenConfiguration(@NotNull TokenConfiguration reference) {
        this.tokenConfiguration.removeConfiguration((SecurityConfiguration)reference);
    }

    protected void bindAuthorizationConfiguration(@NotNull AuthorizationConfiguration reference) {
        this.authorizationConfiguration.addConfiguration((SecurityConfiguration)this.initConfiguration(reference));
    }

    protected void unbindAuthorizationConfiguration(@NotNull AuthorizationConfiguration reference) {
        this.authorizationConfiguration.removeConfiguration((SecurityConfiguration)reference);
    }

    private void initializeConfigurations() {
        this.initConfiguration(this.authorizationConfiguration, ConfigurationParameters.of((String)"restrictionProvider", (Object)((Object)this.restrictionProvider)));
        ImmutableMap userMap = ImmutableMap.of((Object)"authorizableActionProvider", (Object)((Object)this.authorizableActionProvider), (Object)"authorizableNodeName", (Object)((Object)this.authorizableNodeName), (Object)"userAuthenticationFactory", (Object)((Object)this.userAuthenticationFactory));
        this.initConfiguration(this.userConfiguration, ConfigurationParameters.of((Map)userMap));
        this.initConfiguration(this.authenticationConfiguration);
        this.initConfiguration(this.privilegeConfiguration);
    }

    private <T extends SecurityConfiguration> T initConfiguration(@NotNull T config) {
        return this.initConfiguration(config, ConfigurationParameters.EMPTY);
    }

    private <T extends SecurityConfiguration> T initConfiguration(@NotNull T config, @NotNull ConfigurationParameters params) {
        if (config instanceof ConfigurationBase) {
            ConfigurationBase cfg = (ConfigurationBase)config;
            cfg.setSecurityProvider((SecurityProvider)this);
            cfg.setParameters(ConfigurationParameters.of((ConfigurationParameters[])new ConfigurationParameters[]{params, cfg.getParameters()}));
            cfg.setRootProvider(this.rootProvider);
            cfg.setTreeProvider(this.treeProvider);
        }
        return config;
    }

    private CompositeConfiguration initCompositeConfiguration(@NotNull CompositeConfiguration composite, @NotNull SecurityConfiguration defaultConfig) {
        composite.setRootProvider(this.rootProvider);
        composite.setTreeProvider(this.treeProvider);
        composite.setDefaultConfig(this.initDefaultConfiguration(defaultConfig));
        return composite;
    }

    private <T extends SecurityConfiguration> T initDefaultConfiguration(@NotNull T config) {
        if (config instanceof ConfigurationBase) {
            ConfigurationBase cfg = (ConfigurationBase)config;
            cfg.setRootProvider(this.rootProvider);
            cfg.setTreeProvider(this.treeProvider);
        }
        return config;
    }

    protected void bindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    protected void unbindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = null;
    }

    protected void bindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = privilegeConfiguration;
    }

    protected void unbindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = null;
    }

    protected void bindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    protected void unbindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = null;
    }
}

