/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.osgi;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.SplitPersistence;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class SplitPersistenceService {
    @Reference(policyOption=ReferencePolicyOption.GREEDY, target="(role=split-persistence-ro)")
    private SegmentNodeStorePersistence roPersistence;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, target="(role=split-persistence-rw)")
    private SegmentNodeStorePersistence rwPersistence;
    private volatile Registration registration;

    @Activate
    void activate(BundleContext bundleContext) throws IOException {
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(bundleContext);
        this.registration = whiteboard.register(SegmentNodeStorePersistence.class, (Object)new SplitPersistence(this.roPersistence, this.rwPersistence), (Map)new Properties(){
            {
                this.put("service.pid", String.format("%s(%s, %s)", SplitPersistence.class.getName(), SplitPersistenceService.this.roPersistence.getClass().getSimpleName(), SplitPersistenceService.this.rwPersistence.getClass().getSimpleName()));
                this.put("role", "split-persistence");
            }
        });
    }

    @Deactivate
    void deactivate() {
        this.registration.unregister();
    }
}

