/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import java.util.Arrays;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.file.proc.AbstractNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.segment.file.proc.SegmentBlob;
import org.jetbrains.annotations.NotNull;

class BulkSegmentNode
extends AbstractNode {
    private final Proc.Backend backend;
    private final String segmentId;
    private final Proc.Backend.Segment segment;

    BulkSegmentNode(Proc.Backend backend, String segmentId, Proc.Backend.Segment segment) {
        this.backend = backend;
        this.segmentId = segmentId;
        this.segment = segment;
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return Arrays.asList(PropertyStates.createProperty((String)"length", (Object)this.segment.getLength(), (Type)Type.LONG), PropertyStates.createProperty((String)"data", (Object)new SegmentBlob(this.backend, this.segmentId, this.segment), (Type)Type.BINARY), PropertyStates.createProperty((String)"isDataSegment", (Object)false, (Type)Type.BOOLEAN), PropertyStates.createProperty((String)"id", (Object)this.segmentId, (Type)Type.STRING), PropertyStates.createProperty((String)"exists", (Object)true, (Type)Type.BOOLEAN));
    }
}

