/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.oak.plugins.document.CommitValueResolver;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UnmergedBranches;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RecoveryContext
implements RevisionContext {
    private final NodeDocument root;
    private final Clock clock;
    private final int clusterId;
    private final CommitValueResolver resolver;

    RecoveryContext(NodeDocument root, Clock clock, int clusterId, CommitValueResolver resolver) {
        this.root = root;
        this.clock = clock;
        this.clusterId = clusterId;
        this.resolver = resolver;
    }

    @Override
    public UnmergedBranches getBranches() {
        return new UnmergedBranches();
    }

    @Override
    public UnsavedModifications getPendingModifications() {
        return new UnsavedModifications();
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    @NotNull
    public RevisionVector getHeadRevision() {
        return new RevisionVector(this.root.getLastRev().values());
    }

    @Override
    @NotNull
    public Revision newRevision() {
        return Revision.newRevision(this.clusterId);
    }

    @Override
    @NotNull
    public Clock getClock() {
        return this.clock;
    }

    @Override
    @Nullable
    public String getCommitValue(@NotNull Revision changeRevision, @NotNull NodeDocument doc) {
        return this.resolver.resolve(changeRevision, doc);
    }
}

