/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.commons.cache.Cache;
import org.apache.jackrabbit.oak.spi.blob.BlobOptions;
import org.apache.jackrabbit.oak.spi.blob.BlobStoreInputStream;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlobStore
implements GarbageCollectableBlobStore,
Cache.Backend<BlockId, Data> {
    protected static final String HASH_ALGORITHM = "SHA-256";
    protected static final int TYPE_DATA = 0;
    protected static final int TYPE_HASH = 1;
    protected static final int BLOCK_SIZE_LIMIT = 48;
    protected Map<String, WeakReference<String>> inUse = Collections.synchronizedMap(new WeakHashMap());
    private int blockSizeMin = 4096;
    private int blockSize = 0x200000;
    private AtomicReference<byte[]> blockBuffer = new AtomicReference();
    private static final String ALGORITHM = "HmacSHA1";
    private byte[] referenceKey;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BlobStatsCollector statsCollector = BlobStatsCollector.NOOP;

    public void setBlockSizeMin(int x) {
        AbstractBlobStore.validateBlockSize(x);
        this.blockSizeMin = x;
    }

    @Override
    public long getBlockSizeMin() {
        return this.blockSizeMin;
    }

    @Override
    public void setBlockSize(int x) {
        AbstractBlobStore.validateBlockSize(x);
        this.blockSize = x;
    }

    public void setStatsCollector(BlobStatsCollector stats) {
        this.statsCollector = stats;
    }

    protected BlobStatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    private static void validateBlockSize(int x) {
        if (x < 48) {
            throw new IllegalArgumentException("The minimum size must be bigger than a content hash itself; limit = 48");
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeBlob(String tempFilePath) throws IOException {
        String string;
        File file = new File(tempFilePath);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = this.writeBlob(in);
        }
        catch (Throwable throwable) {
            org.apache.commons.io.IOUtils.closeQuietly(in);
            FileUtils.forceDelete((File)file);
            throw throwable;
        }
        org.apache.commons.io.IOUtils.closeQuietly((InputStream)in);
        FileUtils.forceDelete((File)file);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeBlob(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream idStream = new ByteArrayOutputStream();
            this.convertBlobToId(in, idStream, 0, 0L);
            byte[] id = idStream.toByteArray();
            String blobId = StringUtils.convertBytesToHex((byte[])id);
            this.usesBlobId(blobId);
            this.statsCollector.uploadCompleted(blobId);
            String string = blobId;
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public String writeBlob(InputStream in, BlobOptions options) throws IOException {
        return this.writeBlob(in);
    }

    @Override
    public InputStream getInputStream(String blobId) throws IOException {
        return new BlobStoreInputStream(this, blobId, 0L);
    }

    @Override
    public String getReference(@NotNull String blobId) {
        Preconditions.checkNotNull((Object)blobId, (Object)"BlobId must be specified");
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(this.getReferenceKey(), ALGORITHM));
            byte[] hash = mac.doFinal(blobId.getBytes("UTF-8"));
            return blobId + ":" + BaseEncoding.base32Hex().encode(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getBlobId(@NotNull String reference) {
        Preconditions.checkNotNull((Object)reference, (Object)"BlobId must be specified");
        int colon = reference.indexOf(58);
        if (colon != -1) {
            String blobId = reference.substring(0, colon);
            if (reference.equals(this.getReference(blobId))) {
                return blobId;
            }
            this.log.debug("Possibly invalid reference as blobId does not match {}", (Object)reference);
        }
        return null;
    }

    protected byte[] getOrCreateReferenceKey() {
        byte[] referenceKeyValue = new byte[256];
        new SecureRandom().nextBytes(referenceKeyValue);
        this.log.info("Reference key is not specified for the BlobStore in use. Generating a random key. For stable reference ensure that reference key is specified");
        return referenceKeyValue;
    }

    private synchronized byte[] getReferenceKey() {
        if (this.referenceKey == null) {
            this.referenceKey = this.getOrCreateReferenceKey();
        }
        return this.referenceKey;
    }

    public void setReferenceKey(byte[] referenceKey) {
        Preconditions.checkArgument((referenceKey != null ? 1 : 0) != 0, (Object)"Reference key already initialized by default means. To explicitly set it, setReferenceKey must be invoked before its first use");
        this.referenceKey = referenceKey;
    }

    public void setReferenceKeyEncoded(String encodedKey) {
        this.setReferenceKey(BaseEncoding.base64().decode((CharSequence)encodedKey));
    }

    public void setReferenceKeyPlainText(String textKey) {
        this.setReferenceKey(textKey.getBytes(Charsets.UTF_8));
    }

    protected void usesBlobId(String blobId) {
        this.inUse.put(blobId, new WeakReference<String>(blobId));
    }

    @Override
    public void clearInUse() {
        this.inUse.clear();
    }

    private void convertBlobToId(InputStream in, ByteArrayOutputStream idStream, int level, long totalLength) throws IOException {
        int count = 0;
        byte[] block = this.blockBuffer.getAndSet(null);
        if (block == null || block.length != this.blockSize) {
            block = new byte[this.blockSize];
        }
        while (true) {
            int blockLen = IOUtils.readFully((InputStream)in, (byte[])block, (int)0, (int)block.length);
            ++count;
            if (blockLen == 0) break;
            if (blockLen < this.blockSizeMin) {
                idStream.write(0);
                IOUtils.writeVarInt((OutputStream)idStream, (int)blockLen);
                idStream.write(block, 0, blockLen);
                totalLength += (long)blockLen;
            } else {
                MessageDigest messageDigest;
                try {
                    messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException(e);
                }
                messageDigest.update(block, 0, blockLen);
                byte[] digest = messageDigest.digest();
                idStream.write(1);
                IOUtils.writeVarInt((OutputStream)idStream, (int)level);
                if (level > 0) {
                    IOUtils.writeVarLong((OutputStream)idStream, (long)totalLength);
                }
                IOUtils.writeVarLong((OutputStream)idStream, (long)blockLen);
                totalLength += (long)blockLen;
                IOUtils.writeVarInt((OutputStream)idStream, (int)digest.length);
                idStream.write(digest);
                long start = System.nanoTime();
                this.storeBlock(digest, level, Arrays.copyOf(block, blockLen));
                this.statsCollector.uploaded(System.nanoTime() - start, TimeUnit.NANOSECONDS, blockLen);
            }
            if (idStream.size() <= this.blockSize / 2) continue;
            byte[] idBlock = idStream.toByteArray();
            idStream.reset();
            this.convertBlobToId(new ByteArrayInputStream(idBlock), idStream, level + 1, totalLength);
            count = 1;
        }
        this.blockBuffer.set(block);
        if (count > 0 && idStream.size() > this.blockSizeMin) {
            byte[] idBlock = idStream.toByteArray();
            idStream.reset();
            this.convertBlobToId(new ByteArrayInputStream(idBlock), idStream, level + 1, totalLength);
        }
        in.close();
    }

    protected abstract void storeBlock(byte[] var1, int var2, byte[] var3) throws IOException;

    @Override
    public abstract void startMark() throws IOException;

    @Override
    public abstract int sweep() throws IOException;

    protected abstract boolean isMarkEnabled();

    protected abstract void mark(BlockId var1) throws Exception;

    protected void markInUse() throws IOException {
        for (String id : new ArrayList<String>(this.inUse.keySet())) {
            this.mark(id);
        }
    }

    @Override
    public int readBlob(String blobId, long pos, byte[] buff, int off, int length) throws IOException {
        int type;
        block8: {
            byte[] digest;
            if (this.isMarkEnabled()) {
                this.mark(blobId);
            }
            byte[] id = StringUtils.convertHexToBytes((String)blobId);
            ByteArrayInputStream idStream = new ByteArrayInputStream(id);
            while (true) {
                if ((type = idStream.read()) == -1) {
                    this.statsCollector.downloadCompleted(blobId);
                    return -1;
                }
                if (type == 0) {
                    int len = IOUtils.readVarInt((InputStream)idStream);
                    if (pos < (long)len) {
                        IOUtils.skipFully((InputStream)idStream, (long)((int)pos));
                        len = (int)((long)len - pos);
                        if (length < len) {
                            len = length;
                        }
                        IOUtils.readFully((InputStream)idStream, (byte[])buff, (int)off, (int)len);
                        return len;
                    }
                    IOUtils.skipFully((InputStream)idStream, (long)len);
                    pos -= (long)len;
                    continue;
                }
                if (type != 1) break block8;
                int level = IOUtils.readVarInt((InputStream)idStream);
                long totalLength = IOUtils.readVarLong((InputStream)idStream);
                if (level > 0) {
                    IOUtils.readVarLong((InputStream)idStream);
                }
                digest = new byte[IOUtils.readVarInt((InputStream)idStream)];
                IOUtils.readFully((InputStream)idStream, (byte[])digest, (int)0, (int)digest.length);
                if (pos >= totalLength) {
                    pos -= totalLength;
                    continue;
                }
                if (level <= 0) break;
                byte[] block = this.readBlock(digest, 0L);
                idStream = new ByteArrayInputStream(block);
            }
            long readPos = pos - pos % (long)this.blockSize;
            byte[] block = this.readBlock(digest, readPos);
            ByteArrayInputStream in = new ByteArrayInputStream(block);
            IOUtils.skipFully((InputStream)in, (long)(pos - readPos));
            return IOUtils.readFully((InputStream)in, (byte[])buff, (int)off, (int)length);
        }
        throw new IOException("Unknown blobs id type " + type + " for blob " + blobId);
    }

    byte[] readBlock(byte[] digest, long pos) {
        BlockId id = new BlockId(digest, pos);
        return this.load((BlockId)id).data;
    }

    public Data load(BlockId id) {
        byte[] data;
        try {
            data = this.readBlockFromBackend(id);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to read block from backend, id " + id, e);
        }
        if (data == null) {
            throw new IllegalArgumentException("The block with id " + id + " was not found");
        }
        return new Data(data);
    }

    protected abstract byte[] readBlockFromBackend(BlockId var1) throws Exception;

    @Override
    public long getBlobLength(String blobId) throws IOException {
        int type;
        if (this.isMarkEnabled()) {
            this.mark(blobId);
        }
        byte[] id = StringUtils.convertHexToBytes((String)blobId);
        ByteArrayInputStream idStream = new ByteArrayInputStream(id);
        long totalLength = 0L;
        while ((type = idStream.read()) != -1) {
            if (type == 0) {
                int len = IOUtils.readVarInt((InputStream)idStream);
                IOUtils.skipFully((InputStream)idStream, (long)len);
                totalLength += (long)len;
                continue;
            }
            if (type == 1) {
                int level = IOUtils.readVarInt((InputStream)idStream);
                totalLength += IOUtils.readVarLong((InputStream)idStream);
                if (level > 0) {
                    IOUtils.readVarLong((InputStream)idStream);
                }
                int digestLength = IOUtils.readVarInt((InputStream)idStream);
                IOUtils.skipFully((InputStream)idStream, (long)digestLength);
                continue;
            }
            throw new IOException("Datastore id type " + type + " for blob " + blobId);
        }
        return totalLength;
    }

    protected void mark(String blobId) throws IOException {
        try {
            byte[] id = StringUtils.convertHexToBytes((String)blobId);
            ByteArrayInputStream idStream = new ByteArrayInputStream(id);
            this.mark(idStream);
        }
        catch (Exception e) {
            throw new IOException("Mark failed for blob " + blobId, e);
        }
    }

    private void mark(ByteArrayInputStream idStream) throws Exception {
        int type;
        while (true) {
            if ((type = idStream.read()) == -1) {
                return;
            }
            if (type == 0) {
                int len = IOUtils.readVarInt((InputStream)idStream);
                IOUtils.skipFully((InputStream)idStream, (long)len);
                continue;
            }
            if (type != 1) break;
            int level = IOUtils.readVarInt((InputStream)idStream);
            IOUtils.readVarLong((InputStream)idStream);
            if (level > 0) {
                IOUtils.readVarLong((InputStream)idStream);
            }
            byte[] digest = new byte[IOUtils.readVarInt((InputStream)idStream)];
            IOUtils.readFully((InputStream)idStream, (byte[])digest, (int)0, (int)digest.length);
            BlockId id = new BlockId(digest, 0L);
            this.mark(id);
            if (level <= 0) continue;
            byte[] block = this.readBlock(digest, 0L);
            idStream = new ByteArrayInputStream(block);
            this.mark(idStream);
        }
        throw new IOException("Unknown blobs id type " + type);
    }

    @Override
    public Iterator<String> resolveChunks(String blobId) throws IOException {
        return new ChunkIterator(blobId);
    }

    @Override
    public boolean deleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        return (long)chunkIds.size() == this.countDeleteChunks(chunkIds, maxLastModifiedTime);
    }

    @Override
    public void close() throws Exception {
    }

    class ChunkIterator
    implements Iterator<String> {
        private static final int BATCH = 2048;
        private final ArrayDeque<String> queue;
        private final ArrayDeque<ByteArrayInputStream> streamsStack;

        public ChunkIterator(String blobId) {
            byte[] id = StringUtils.convertHexToBytes((String)blobId);
            ByteArrayInputStream idStream = new ByteArrayInputStream(id);
            this.queue = new ArrayDeque(2048);
            this.streamsStack = new ArrayDeque();
            this.streamsStack.push(idStream);
        }

        @Override
        public boolean hasNext() {
            if (!this.queue.isEmpty()) {
                return true;
            }
            try {
                while (this.queue.size() < 2048 && this.streamsStack.peekFirst() != null) {
                    ByteArrayInputStream idStream = this.streamsStack.peekFirst();
                    int type = idStream.read();
                    if (type == -1) {
                        this.streamsStack.pop();
                        continue;
                    }
                    if (type == 0) {
                        int len = IOUtils.readVarInt((InputStream)idStream);
                        IOUtils.skipFully((InputStream)idStream, (long)len);
                        continue;
                    }
                    if (type == 1) {
                        int level = IOUtils.readVarInt((InputStream)idStream);
                        IOUtils.readVarLong((InputStream)idStream);
                        if (level > 0) {
                            IOUtils.readVarLong((InputStream)idStream);
                        }
                        byte[] digest = new byte[IOUtils.readVarInt((InputStream)idStream)];
                        IOUtils.readFully((InputStream)idStream, (byte[])digest, (int)0, (int)digest.length);
                        if (level > 0) {
                            this.queue.add(StringUtils.convertBytesToHex((byte[])digest));
                            byte[] block = AbstractBlobStore.this.readBlock(digest, 0L);
                            idStream = new ByteArrayInputStream(block);
                            this.streamsStack.push(idStream);
                            continue;
                        }
                        this.queue.add(StringUtils.convertBytesToHex((byte[])digest));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return !this.queue.isEmpty();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No data");
            }
            return this.queue.remove();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }

    public static class Data
    implements Cache.Value {
        final byte[] data;

        Data(byte[] data) {
            this.data = data;
        }

        public String toString() {
            String s = StringUtils.convertBytesToHex((byte[])this.data);
            return s.length() > 100 ? s.substring(0, 100) + ".. (len=" + this.data.length + ")" : s;
        }

        public int getMemory() {
            return this.data.length;
        }
    }

    public static class BlockId {
        final byte[] digest;
        final long pos;

        BlockId(byte[] digest, long pos) {
            this.digest = digest;
            this.pos = pos;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof BlockId)) {
                return false;
            }
            BlockId o = (BlockId)other;
            return Arrays.equals(this.digest, o.digest) && this.pos == o.pos;
        }

        public int hashCode() {
            return Arrays.hashCode(this.digest) ^ (int)(this.pos >> 32) ^ (int)this.pos;
        }

        public String toString() {
            return StringUtils.convertBytesToHex((byte[])this.digest) + "@" + this.pos;
        }

        public byte[] getDigest() {
            return this.digest;
        }

        public long getPos() {
            return this.pos;
        }
    }
}

