/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.websites.model;

import org.silverpeas.components.websites.model.SitePK;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;

public class SiteDetail
extends PublicationDetail {
    private static final long serialVersionUID = 1435448496246944796L;
    private SitePK sitePk = new SitePK("", "");
    private int siteType;
    private int state;
    private int popup = 1;
    private String silverObjectId;
    private String positions;
    public static final String SITE_TYPE = "Website";

    public SiteDetail(String siteId, String applicationId, String name, String description, String page, int type, String creatorId) {
        this.setName(name);
        this.setDescription(description);
        this.setCreatorId(creatorId);
        this.setImportance(type);
        this.setVersion(siteId);
        this.setKeywords("");
        this.setContentPagePath(page);
        SitePK sitePK = new SitePK(siteId, applicationId);
        this.setSitePK(sitePK);
    }

    public SitePK getSitePK() {
        return this.sitePk;
    }

    public void setSitePK(SitePK val) {
        this.sitePk = new SitePK(val.getId(), val.getComponentName());
    }

    public int getSiteType() {
        return this.siteType;
    }

    public void setSiteType(int val) {
        this.siteType = val;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int val) {
        this.state = val;
    }

    public String getURL() {
        return "searchResult?Type=Site&Id=" + this.getId();
    }

    public String getId() {
        return this.getSitePK().getId();
    }

    public String getInstanceId() {
        return this.getSitePK().getComponentName();
    }

    public String getPositions() {
        return this.positions;
    }

    public void setPositions(String positions) {
        this.positions = positions;
    }

    public String toString() {
        return this.sitePk.getId() + "|" + this.getName() + "|" + this.getDescription() + "|" + this.getContentPagePath() + "||" + this.siteType + "|" + this.getCreatorId() + "|" + String.valueOf(this.getCreationDate()) + "|" + this.state;
    }

    public int getPopup() {
        return this.popup;
    }

    public void setPopup(int popup) {
        this.popup = popup;
    }

    public String getContributionType() {
        return SITE_TYPE;
    }

    public String getSilverpeasContentId() {
        if (this.silverObjectId == null) {
            ContentManagementEngine contentMgtEngine = ContentManagementEngineProvider.getContentManagementEngine();
            try {
                int objectId = contentMgtEngine.getSilverContentId(this.getId(), this.getInstanceId());
                if (objectId >= 0) {
                    this.silverObjectId = String.valueOf(objectId);
                }
            }
            catch (ContentManagerException ex) {
                this.silverObjectId = null;
            }
        }
        return this.silverObjectId;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

