/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.survey;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerPK;
import org.silverpeas.core.questioncontainer.container.service.QuestionContainerService;

@Service
public class SurveyContentManager
extends AbstractSilverpeasContentManager {
    private static final String SURVEY_CONTENT_ICON_FILE_NAME = "surveySmall.gif";
    private static final String POLLING_CONTENT_ICON_FILE_NAME = "pollingStationSmall.gif";
    @Inject
    private QuestionContainerService questionContainerService;

    protected SurveyContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        if (componentInstanceId.startsWith("pollingStation")) {
            return POLLING_CONTENT_ICON_FILE_NAME;
        }
        return SURVEY_CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        return Optional.ofNullable(this.getQuestionContainerService().getQuestionContainerHeader(new QuestionContainerPK(resourceId, "useless", componentInstanceId)));
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        List pks = resourceReferences.stream().map(r -> new QuestionContainerPK(r.getLocalId(), "useless", r.getComponentInstanceId())).collect(Collectors.toList());
        return new ArrayList<Contribution>(this.getQuestionContainerService().getQuestionContainerHeaders(pks));
    }

    private QuestionContainerService getQuestionContainerService() {
        return this.questionContainerService;
    }
}

