/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.silvercrawler;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.components.silvercrawler.model.SilverCrawlerRuntimeException;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.index.indexing.model.RepositoryIndexer;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public class ScheduledIndexFiles
implements SchedulerEventListener {
    public static final String SILVERCRAWLERENGINE_JOB_NAME = "SilverCrawlerEngineJob";

    public void initialize() {
        try {
            SettingBundle resources = ResourceLocator.getSettingBundle((String)"org.silverpeas.silvercrawler.settings.silverCrawlerSettings");
            String cron = resources.getString("cronScheduledIndex");
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(SILVERCRAWLERENGINE_JOB_NAME);
            JobTrigger trigger = JobTrigger.triggerAt((String)cron);
            scheduler.scheduleJob(SILVERCRAWLERENGINE_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void doScheduledIndex() {
        try {
            OrganizationController orga = OrganizationController.get();
            List instances = orga.getComponentsWithParameterValue("periodicIndex", "yes");
            for (ComponentInstLight instance : instances) {
                RepositoryIndexer repositoryIndexer = new RepositoryIndexer(null, instance.getId());
                ArrayList<String> profiles = new ArrayList<String>();
                profiles.add("admin");
                String[] adminIds = orga.getUsersIdsByRoleNames(instance.getId(), profiles);
                String adminId = "0";
                if (adminIds != null && adminIds.length > 0) {
                    adminId = adminIds[0];
                }
                Path pathRepository = Paths.get(instance.getParameterValue("directory"), new String[0]);
                repositoryIndexer.addPath(pathRepository, adminId);
            }
        }
        catch (Exception e) {
            throw new SilverCrawlerRuntimeException(e);
        }
    }

    public void triggerFired(SchedulerEvent anEvent) {
        this.doScheduledIndex();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
        SilverLogger.getLogger((Object)this).error("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull", new Object[0]);
    }
}

