/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.service;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;

@Service
public class QuickInfoContentManager
extends AbstractSilverpeasContentManager {
    private static final String CONTENT_ICON_FILE_NAME = "quickinfoSmall.gif";

    protected QuickInfoContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        return CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        return Optional.ofNullable(this.getPublicationService().getDetail(new PublicationPK(resourceId, componentInstanceId)));
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        List pks = resourceReferences.stream().map(r -> new PublicationPK(r.getLocalId(), r.getComponentInstanceId())).collect(Collectors.toList());
        return new ArrayList<Contribution>(this.getPublicationService().getPublications(pks));
    }

    protected <T extends Contribution> SilverContentVisibility computeSilverContentVisibility(T contribution) {
        PublicationDetail pubDetail = (PublicationDetail)contribution;
        return new SilverContentVisibility(pubDetail.getBeginDate(), pubDetail.getEndDate(), false);
    }

    public void deleteSilverContent(Connection con, PublicationPK pubPK) throws ContentManagerException {
        this.deleteSilverContent(con, pubPK.getId(), pubPK.getComponentName());
    }

    private PublicationService getPublicationService() {
        return PublicationService.get();
    }
}

