/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.service;

import java.util.List;
import java.util.Map;
import org.silverpeas.components.whitepages.service.MixedSearchService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.indexing.model.FieldDescription;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.index.search.model.SearchEngineException;
import org.silverpeas.core.index.search.model.SearchResult;
import org.silverpeas.core.search.SearchService;
import org.silverpeas.core.util.CollectionUtil;

@Service
public class MixedSearchServiceImpl
implements MixedSearchService {
    @Override
    public List<SearchResult> search(MixedSearchService.SearchQuery searchQuery) throws SearchEngineException {
        QueryDescription query = new QueryDescription(searchQuery.getQuery());
        query.setSearchingUser(searchQuery.getUserId());
        query.addComponent(searchQuery.getComponentId());
        Map<String, String> xmlFields = searchQuery.getXmlFields();
        String xmlTemplate = searchQuery.getXmlTemplate();
        if (xmlFields != null && !xmlFields.isEmpty() && xmlTemplate != null) {
            for (Map.Entry<String, String> entry : xmlFields.entrySet()) {
                String value = entry.getValue();
                value = value.trim().replace("##", " AND ");
                query.addFieldQuery(new FieldDescription(xmlTemplate + "$$" + entry.getKey(), value, searchQuery.getLanguage()));
            }
        }
        if (CollectionUtil.isNotEmpty(searchQuery.getFieldsQuery())) {
            query.setFieldQueries(searchQuery.getFieldsQuery());
        }
        query.setTaxonomyPosition(searchQuery.getTaxonomyPosition());
        SearchService searchService = SearchService.get();
        return searchService.search(query);
    }
}

