/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.service.notification;

import java.util.Collection;
import java.util.MissingResourceException;
import org.silverpeas.components.questionreply.model.Question;
import org.silverpeas.components.questionreply.model.Reply;
import org.silverpeas.components.questionreply.service.notification.AbstractReplyNotifier;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberMapBySubscriberType;

public class SubscriptionNotifier
extends AbstractReplyNotifier
implements UserSubscriptionNotificationBehavior {
    private final SubscriptionSubscriberMapBySubscriberType subscriberIdsByTypes;

    public SubscriptionNotifier(User sender, Question question, Reply reply) {
        super(question, reply, sender);
        this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfComponent((String)question.getInstanceId()).indexBySubscriberType();
    }

    protected String getTemplateFileName() {
        return "reply_subscription";
    }

    @Override
    protected String getBundleSubjectKey() {
        return "questionReply.subscription.title";
    }

    @Override
    protected String getTitle(String language) {
        String translation;
        try {
            translation = this.getBundle(language).getString(this.getBundleSubjectKey());
        }
        catch (MissingResourceException ex) {
            translation = "Answer to %1$s";
        }
        return String.format(translation, ((Question)((Object)this.getResource())).getTitle());
    }

    protected Collection<String> getUserIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.USER)).getAllIds();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return ((SubscriptionSubscriberList)this.subscriberIdsByTypes.get((Object)SubscriberType.GROUP)).getAllIds();
    }
}

