/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element;

import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Attr;

public abstract class OdfStyleableShapeElement
extends OdfStylableElement {
    private static final long serialVersionUID = 3604813885619852184L;
    private static OdfName PresStyleAttrName = OdfName.newName(OdfDocumentNamespace.PRESENTATION, "style-name");
    private static OdfName DrawStyleAttrName = OdfName.newName(OdfDocumentNamespace.DRAW, "style-name");

    public OdfStyleableShapeElement(OdfFileDom ownerDocument, OdfName name) {
        super(ownerDocument, name, OdfStyleFamily.Graphic, DrawStyleAttrName);
    }

    protected void adjustStyleNameAttrib(String uri, String localname) {
        if (DrawStyleAttrName.equals(uri, localname)) {
            this.mStyleNameAttrib = DrawStyleAttrName;
            this.mFamily = OdfStyleFamily.Graphic;
        } else if (PresStyleAttrName.equals(uri, localname)) {
            this.mStyleNameAttrib = PresStyleAttrName;
            this.mFamily = OdfStyleFamily.Presentation;
        }
    }

    @Override
    public void setAttributeNS(String uri, String localname, String value) {
        if (value != null && value.length() != 0) {
            this.adjustStyleNameAttrib(uri, localname);
        }
        super.setAttributeNS(uri, localname, value);
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        String uri = newAttr.getNamespaceURI();
        String localname = newAttr.getName();
        this.adjustStyleNameAttrib(uri, localname);
        return super.setAttributeNodeNS(newAttr);
    }
}

