/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.silverpeas.components.community.AlreadyMemberException;
import org.silverpeas.components.community.model.CommunityMembership;
import org.silverpeas.components.community.model.CommunityMembershipsProvider;
import org.silverpeas.components.community.model.MembershipStatus;
import org.silverpeas.components.community.repository.CommunityOfUsersRepository;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.component.model.InheritableSpaceRoles;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.CommunityMembersGroup;
import org.silverpeas.core.admin.service.CommunityMembershipService;
import org.silverpeas.core.admin.space.SpaceHomePageType;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.Pair;

@Entity
@Table(name="SC_Community")
@NamedQueries(value={@NamedQuery(name="CommunityByComponentInstanceId", query="select c from CommunityOfUsers c where c.componentInstanceId = :componentInstanceId"), @NamedQuery(name="CommunityBySpaceId", query="select c from CommunityOfUsers c where c.spaceId = :spaceId")})
public class CommunityOfUsers
extends BasicJpaEntity<CommunityOfUsers, UuidIdentifier> {
    private static final long serialVersionUID = -4908726669864467915L;
    @Column(name="spaceId", nullable=false)
    @NotNull
    private String spaceId;
    @Column(name="instanceId", nullable=false)
    @NotNull
    private String componentInstanceId;
    Integer groupId;
    private String homePage;
    @Enumerated(value=EnumType.ORDINAL)
    private SpaceHomePageType homePageType;
    private URL charterURL;
    @Transient
    private transient CommunityMembershipsProvider provider;
    @Transient
    private transient CommunitySpace communitySpace;

    protected CommunityOfUsers() {
    }

    public CommunityOfUsers(String componentInstanceId, String spaceId) {
        this.componentInstanceId = componentInstanceId;
        this.spaceId = spaceId;
        this.communitySpace = new CommunitySpace(this);
    }

    public static List<CommunityOfUsers> getAll() {
        CommunityOfUsersRepository repository = CommunityOfUsersRepository.get();
        return repository.getAll();
    }

    public static Optional<CommunityOfUsers> getByComponentInstanceId(String instanceId) {
        CommunityOfUsersRepository repository = CommunityOfUsersRepository.get();
        return repository.getByComponentInstanceId(instanceId);
    }

    public static Optional<CommunityOfUsers> getBySpaceId(String spaceId) {
        CommunityOfUsersRepository repository = CommunityOfUsersRepository.get();
        return repository.getBySpaceId(spaceId);
    }

    public WysiwygContent getSpacePresentationContent() {
        return WysiwygController.get((String)this.getComponentInstanceId(), (String)"SpaceFacade", null);
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public boolean isMember(User user) {
        return this.getCommunitySpace().getAllUsers().contains(user.getId());
    }

    public Set<SilverpeasRole> getUserRoles(User user) {
        return Set.copyOf(ComponentAccessControl.get().getUserRoles(user.getId(), (Object)this.getComponentInstanceId(), AccessControlContext.init()));
    }

    public Pair<String, SpaceHomePageType> getHomePage() {
        return Pair.of((Object)Optional.ofNullable(this.homePage).orElse(""), (Object)Optional.ofNullable(this.homePageType).orElse(SpaceHomePageType.STANDARD));
    }

    public URL getCharterURL() {
        return this.charterURL;
    }

    public void setCharterURL(@Nonnull URL charterURL) {
        Objects.requireNonNull(charterURL);
        this.charterURL = charterURL;
    }

    public void setCharterURL(String charterURL) throws MalformedURLException {
        this.charterURL = new URL(charterURL);
    }

    public void unsetCharterURL() {
        this.charterURL = null;
    }

    public void setHomePage(String homePage, SpaceHomePageType homePageType) {
        this.homePage = homePage;
        this.homePageType = homePageType;
    }

    public CommunityMembership addAsAPendingMember(User user) {
        this.checkAlreadyMember(user);
        this.getMembershipsProvider().get(user).map(CommunityMembership::getStatus).filter(s -> s == MembershipStatus.PENDING).ifPresent(s -> {
            throw new AlreadyMemberException("The membership of the user " + user.getId() + " is already pending!");
        });
        return (CommunityMembership)((Object)Transaction.performInOne(() -> {
            CommunityMembership membership = CommunityMembership.asMember(user, this);
            membership.setStatus(MembershipStatus.PENDING);
            membership.save();
            return membership;
        }));
    }

    public CommunityMembership addAsMember(User user, SilverpeasRole role) {
        if (!InheritableSpaceRoles.isASpaceRole((SilverpeasRole)role)) {
            throw new IllegalArgumentException("The role " + role.getName() + " isn't a role of a space");
        }
        this.checkAlreadyMember(user);
        return (CommunityMembership)((Object)Transaction.performInOne(() -> {
            this.getCommunitySpace().addUser(user, role);
            return this.commitMembership(user);
        }));
    }

    public CommunityMembership refuseMembership(User user) {
        CommunityMembership membership = this.getMembershipsProvider().get(user).filter(m -> m.getStatus().isPending()).orElseThrow(() -> new IllegalStateException("The user " + user.getId() + " has no pending membership to the community " + this.getId()));
        return (CommunityMembership)((Object)Transaction.performInOne(() -> {
            membership.setStatus(MembershipStatus.REFUSED);
            membership.save();
            return membership;
        }));
    }

    @Nullable
    public CommunityMembership removeMembership(User user) {
        return (CommunityMembership)((Object)Transaction.performInOne(() -> {
            this.getCommunitySpace().removeUser(user);
            return this.getMembershipsProvider().get(user).map(m -> {
                m.delete();
                return m;
            }).orElse(null);
        }));
    }

    public CommunityMembershipsProvider getMembershipsProvider() {
        if (this.provider == null) {
            this.provider = CommunityMembershipsProvider.getProvider(this);
        }
        return this.provider;
    }

    public void save() {
        if (!this.isPersisted()) {
            throw new IllegalStateException("This community isn't a persisted one!");
        }
        Transaction.performInOne(() -> {
            CommunityOfUsersRepository.get().save((IdentifiableEntity)this);
            return null;
        });
    }

    public void delete() {
        Transaction.performInOne(() -> {
            CommunityOfUsersRepository repository = CommunityOfUsersRepository.get();
            repository.delete((IdentifiableEntity[])new CommunityOfUsers[]{this});
            repository.flush();
            this.getCommunitySpace().delete();
            return null;
        });
    }

    public GroupDetail getGroupOfMembers() {
        if (!this.isPersisted()) {
            return null;
        }
        try {
            return this.getCommunitySpace().getOrCreateMembersGroup();
        }
        catch (AdminException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    CommunitySpace getCommunitySpace() {
        if (this.communitySpace == null) {
            this.communitySpace = new CommunitySpace(this);
        }
        return this.communitySpace;
    }

    private CommunityMembership commitMembership(User user) {
        Optional<CommunityMembership> mayBeMember = this.getMembershipsProvider().get(user);
        CommunityMembership m = mayBeMember.filter(mb -> mb.getStatus().isPending()).orElseGet(() -> CommunityMembership.asMember(user, this));
        m.setStatus(MembershipStatus.COMMITTED);
        m.save();
        return m;
    }

    private void synchronizeRemovingIfAny(User user) {
        Transaction.performInOne(() -> {
            this.getMembershipsProvider().get(user).filter(m -> m.getStatus().isMember()).ifPresent(CommunityMembership::delete);
            return null;
        });
    }

    private void checkAlreadyMember(User user) {
        if (this.isMember(user)) {
            throw new AlreadyMemberException("User " + user.getId() + " is already a member of the community " + this.getId());
        }
        this.synchronizeRemovingIfAny(user);
    }

    static class CommunitySpace {
        private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.components.community.settings.communitySettings");
        private final CommunityMembershipService communityService = CommunityMembershipService.get();
        private final CommunityOfUsers community;

        public CommunitySpace(CommunityOfUsers community) {
            this.community = community;
        }

        public void addUser(@NonNull User user, @NonNull SilverpeasRole role) {
            Objects.requireNonNull(user);
            Objects.requireNonNull(role);
            this.execute(() -> {
                CommunityMembersGroup group = this.getOrCreateMembersGroup();
                this.communityService.addMember(user, group, role);
            });
        }

        public void removeUser(@NonNull User user) {
            Objects.requireNonNull(user);
            this.execute(() -> {
                CommunityMembersGroup group = this.getOrCreateMembersGroup();
                this.communityService.removeMember(user, group);
            });
        }

        public void delete() {
            this.execute(() -> this.communityService.deleteCommunity(this.community.spaceId, this.community.groupId == null ? null : String.valueOf(this.community.groupId)));
        }

        public Set<String> getAllUsers() {
            HashSet<String> users = new HashSet<String>();
            this.execute(() -> {
                SpaceInst space = this.getSilverpeasSpace();
                this.streamOnNonInheritedSpaceProfiles(space).flatMap(p -> p.getAllUsers().stream()).forEach(users::add);
            });
            SynchronizationTask spaceSynchro = this.community.getCommunitySpace().getSynchronizationTask();
            spaceSynchro.synchronizeMembersGroup(users);
            return users;
        }

        public Set<SpaceProfileInst> getAllSpaceProfilesOfUser(String userId) {
            HashSet<SpaceProfileInst> profiles = new HashSet<SpaceProfileInst>();
            this.execute(() -> {
                SpaceInst space = this.getSilverpeasSpace();
                this.streamOnNonInheritedSpaceProfiles(space).filter(p -> p.getAllUsers().contains(userId)).forEach(profiles::add);
            });
            return profiles;
        }

        Optional<CommunityMembersGroup> getMembersGroup() {
            if (this.community.groupId == null) {
                return Optional.empty();
            }
            Mutable group = Mutable.empty();
            this.execute(() -> group.set((Object)this.communityService.getGroup(String.valueOf(this.community.groupId))));
            return Optional.ofNullable((CommunityMembersGroup)group.get());
        }

        private SynchronizationTask getSynchronizationTask() {
            return new SynchronizationTask();
        }

        private CommunityMembersGroup createMembersGroup() throws AdminException {
            String symbol = settings.getString("community.group.symbol", "");
            CommunityMembersGroup group = this.communityService.setUpCommunity(this.community.spaceId, symbol);
            this.community.groupId = Integer.parseInt(group.getId());
            this.community.save();
            return group;
        }

        private Stream<SpaceProfileInst> streamOnNonInheritedSpaceProfiles(SpaceInst space) {
            return space.getAllSpaceProfilesInst().stream().filter(Predicate.not(SpaceProfileInst::isManager).and(Predicate.not(BaseRightProfile::isInherited)));
        }

        private CommunityMembersGroup getOrCreateMembersGroup() throws AdminException {
            CommunityMembersGroup group;
            if (this.community.groupId == null) {
                group = this.createMembersGroup();
            } else {
                group = this.getMembersGroup().orElseThrow(() -> new IllegalStateException("No group of members defined for the community " + this.community.getId()));
                String symbol = settings.getString("community.group.symbol", "") + " ";
                SpaceInst space = this.getSilverpeasSpace();
                if (symbol.isBlank() && !group.getName().equals(space.getName()) || !symbol.isBlank() && !group.getName().startsWith(symbol)) {
                    group.setName((symbol + space.getName()).trim());
                    this.communityService.updateGroup(group);
                }
            }
            return group;
        }

        private SpaceInst getSilverpeasSpace() throws AdminException {
            return this.communityService.getCommunity(this.community.spaceId);
        }

        private void execute(AdminTask task) {
            try {
                task.perform();
            }
            catch (AdminException e) {
                throw new SilverpeasRuntimeException("Unexpected error: " + e.getMessage());
            }
        }

        class SynchronizationTask {
            SynchronizationTask() {
            }

            void synchronizeMembersGroup(Set<String> usersPlayingARole) {
                CommunitySpace.this.execute(() -> {
                    if (usersPlayingARole.isEmpty()) {
                        return;
                    }
                    Administration administration = Administration.get();
                    CommunityMembersGroup group = CommunitySpace.this.getOrCreateMembersGroup();
                    Set<String> members = Set.of(group.getUserIds());
                    for (String userId : usersPlayingARole) {
                        if (members.contains(userId)) continue;
                        administration.addUserInGroup(userId, group.getId());
                    }
                    for (String memberId : members) {
                        if (usersPlayingARole.contains(memberId)) continue;
                        administration.removeUserFromGroup(memberId, group.getId());
                    }
                });
            }
        }

        @FunctionalInterface
        private static interface AdminTask {
            public void perform() throws AdminException;
        }
    }
}

