/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.silverpeas.components.community.CommunityComponentSettings;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.service.CommunityFactory;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.bundle.LocalizationBundle;

@Provider
public class CommunityInstanceFactory
implements CommunityFactory {
    @NonNull
    public ComponentInst createCommunity(@NonNull SpaceInst communitySpace) {
        Objects.requireNonNull(communitySpace);
        String language = User.getCurrentUser().getUserPreferences().getLanguage();
        LocalizationBundle bundle = CommunityComponentSettings.getMessagesIn(language);
        Optional maybeComponent = WAComponent.getByName((String)"community");
        WAComponent component = (WAComponent)maybeComponent.orElseThrow(() -> new IllegalStateException("The community application should be defined!"));
        ComponentInst membershipMgtApp = new ComponentInst();
        membershipMgtApp.setName(component.getName());
        membershipMgtApp.setDomainFatherId(communitySpace.getId());
        membershipMgtApp.setInheritanceBlocked(true);
        membershipMgtApp.setPublic(true);
        membershipMgtApp.setHidden(false);
        membershipMgtApp.setLabel(bundle.getString("community.membership.management.label"));
        membershipMgtApp.setDescription(bundle.getString("community.membership.management.desc"));
        membershipMgtApp.setOrderNum(0);
        membershipMgtApp.setParameters(new ArrayList(component.getParameters()));
        return membershipMgtApp;
    }
}

