/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.scheduleevent.service.model.dao;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.silverpeas.components.scheduleevent.service.model.beans.Response;
import org.silverpeas.components.scheduleevent.service.model.beans.ScheduleEvent;
import org.silverpeas.components.scheduleevent.service.model.dao.ScheduleEventDao;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.comment.service.CommentServiceProvider;

@Repository
@Transactional
public class ScheduleEventDaoImpl
implements ScheduleEventDao {
    @PersistenceContext
    private EntityManager theEntityManager;

    private EntityManager getEntityManager() {
        return this.theEntityManager;
    }

    @Override
    public void createScheduleEvent(ScheduleEvent scheduleEvent) {
        this.getEntityManager().persist((Object)scheduleEvent);
    }

    @Override
    public void deleteScheduleEvent(ScheduleEvent scheduleEvent) {
        EntityManager entityManager = this.getEntityManager();
        ScheduleEvent attachedEvent = (ScheduleEvent)entityManager.merge((Object)scheduleEvent);
        Iterator<Response> iterator = attachedEvent.getResponses().iterator();
        while (iterator.hasNext()) {
            Response response = iterator.next();
            iterator.remove();
            entityManager.remove((Object)response);
        }
        entityManager.remove((Object)attachedEvent);
        CommentServiceProvider.getCommentService().deleteAllCommentsOnResource(ScheduleEvent.getResourceType(), new ResourceReference(scheduleEvent.getId(), "scheduleEventTool"));
    }

    @Override
    public ScheduleEvent getScheduleEvent(String scheduleEventId) {
        return (ScheduleEvent)this.getEntityManager().find(ScheduleEvent.class, (Object)scheduleEventId);
    }

    @Override
    public Set<ScheduleEvent> listScheduleEventsByCreatorId(String userId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("findByAuthor", ScheduleEvent.class);
        query.setParameter("authorId", (Object)Integer.valueOf(userId));
        List events = query.getResultList();
        return new HashSet<ScheduleEvent>(events);
    }

    @Override
    public Set<ScheduleEvent> listScheduleEventsByContributorId(String userId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("findByContributor", ScheduleEvent.class);
        query.setParameter("contributorId", (Object)Integer.valueOf(userId));
        List events = query.getResultList();
        return new HashSet<ScheduleEvent>(events);
    }

    @Override
    public void updateScheduleEvent(ScheduleEvent scheduleEvent) {
        this.getEntityManager().merge((Object)scheduleEvent);
    }

    @Override
    public void purgeResponseScheduleEvent(ScheduleEvent scheduleEvent, int userId) {
        ScheduleEvent attachedEvent = (ScheduleEvent)this.getEntityManager().merge((Object)scheduleEvent);
        Iterator<Response> iterator = attachedEvent.getResponses().iterator();
        while (iterator.hasNext()) {
            Response response = iterator.next();
            if (response.getUserId() != userId) continue;
            iterator.remove();
            this.getEntityManager().remove((Object)response);
        }
    }
}

