/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.model;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.node.model.NodeDetail;

public class TopicComparator
implements Comparator<NodeDetail> {
    private static final String DEFAULT_NAME = "*";
    private boolean useCriteria;
    private Map<String, Integer> namesWeights;

    public TopicComparator() {
        this.useCriteria = false;
    }

    public TopicComparator(String[] criteria) {
        if (criteria != null) {
            this.namesWeights = new HashMap<String, Integer>();
            int i = 0;
            for (i = 0; i < criteria.length; ++i) {
                this.namesWeights.put(criteria[i].toLowerCase(), i);
            }
            if (i > 0 && !this.namesWeights.containsKey(DEFAULT_NAME)) {
                this.namesWeights.put(DEFAULT_NAME, i);
            }
        }
        this.useCriteria = this.namesWeights != null && !this.namesWeights.isEmpty();
    }

    private Integer getNameWeight(String name) {
        return this.namesWeights.containsKey(name) ? this.namesWeights.get(name) : this.namesWeights.get(DEFAULT_NAME);
    }

    @Override
    public int compare(NodeDetail node1, NodeDetail node2) {
        int result = 0;
        if (node1.isChild() && node2.isChild()) {
            String name1 = node1.getName().toLowerCase();
            String name2 = node2.getName().toLowerCase();
            if (this.useCriteria) {
                result = this.getNameWeight(name1).compareTo(this.getNameWeight(name2));
            }
            if (result == 0) {
                result = name1.compareTo(name2);
            }
        }
        return result;
    }
}

