/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.almanach;

import java.time.ZoneId;
import java.util.Arrays;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public final class AlmanachSettings {
    public static final String COMPONENT_NAME = "almanach";
    public static final String SETTINGS_PATH = "org.silverpeas.almanach.settings.almanachSettings";
    public static final String MESSAGES_PATH = "org.silverpeas.almanach.multilang.almanach";
    public static final String ICONS_PATH = "org.silverpeas.almanach.settings.almanachIcons";
    public static final String ALMANACH_IN_SUBSPACES = "0";
    public static final String ALMANACH_IN_SPACE_AND_SUBSPACES = "1";
    public static final String ALL_ALMANACHS = "2";

    private AlmanachSettings() {
    }

    public static LocalizationBundle getMessagesIn(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public static SettingBundle getSettings() {
        return ResourceLocator.getSettingBundle((String)SETTINGS_PATH);
    }

    public static LocalizationBundle getIcons() {
        return ResourceLocator.getLocalizationBundle((String)ICONS_PATH);
    }

    public static ZoneId getZoneId() {
        return ZoneId.of(AlmanachSettings.getSettings().getString("almanach.timezone"));
    }

    public static boolean isCalendarWeekendVisible(String componentInstanceId) {
        return !StringUtil.getBooleanValue((String)OrganizationController.get().getComponentParameterValue(componentInstanceId, "weekendNotVisible"));
    }

    public static String getDefaultCalendarView(String componentInstanceId) {
        String defaultView = OrganizationController.get().getComponentParameterValue(componentInstanceId, "defaultView");
        return StringUtil.defaultStringIfNotDefined((String)defaultView, (String)"MONTHLY");
    }

    public static boolean isPdcUsed(String componentInstanceId) {
        return StringUtil.getBooleanValue((String)OrganizationController.get().getComponentParameterValue(componentInstanceId, "usePdc"));
    }

    public static boolean isFilterOnPdcActivated(String componentInstanceId) {
        return StringUtil.getBooleanValue((String)OrganizationController.get().getComponentParameterValue(componentInstanceId, "filterOnPdc"));
    }

    public static int getNbOccurrenceLimitOfNextEventView() {
        int limit = AlmanachSettings.getSettings().getInteger("almanach.nextEvents.limit", -1);
        if (limit == -1) {
            limit = AlmanachSettings.getCommonSetting().getInteger("calendar.nextEvents.limit");
        }
        return limit;
    }

    public static int getNbOccurrenceLimitOfShortNextEventView() {
        int limit = AlmanachSettings.getSettings().getInteger("almanach.nextEvents.short.limit", -1);
        if (limit == -1) {
            limit = AlmanachSettings.getCommonSetting().getInteger("calendar.nextEvents.short.limit");
        }
        return limit;
    }

    public static Integer[] getNextEventTimeWindows() {
        String timeWindows = AlmanachSettings.getSettings().getString("almanach.nextEvents.time.windows", "");
        if (StringUtil.isNotDefined((String)timeWindows)) {
            timeWindows = AlmanachSettings.getCommonSetting().getString("calendar.nextEvents.time.windows");
        }
        return (Integer[])Arrays.stream(timeWindows.split(",")).map(w -> Integer.parseInt(w.trim())).toArray(Integer[]::new);
    }

    public static String getAggregationMode() {
        return AlmanachSettings.getSettings().getString("almanachAgregationMode", ALMANACH_IN_SUBSPACES);
    }

    private static SettingBundle getCommonSetting() {
        return ResourceLocator.getSettingBundle((String)"org.silverpeas.calendar.settings.calendar");
    }
}

