/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.security.user.query.ConditionVisitor;
import org.apache.jackrabbit.oak.security.user.query.RelationOp;
import org.jetbrains.annotations.NotNull;

interface Condition {
    public void accept(@NotNull ConditionVisitor var1) throws RepositoryException;

    public static class Or
    extends Compound {
        public Or(@NotNull Condition condition1, @NotNull Condition condition2) {
            super(condition1, condition2);
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static class And
    extends Compound {
        public And(@NotNull Condition condition1, @NotNull Condition condition2) {
            super(condition1, condition2);
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static abstract class Compound
    implements Condition,
    Iterable<Condition> {
        private final List<Condition> conditions = new ArrayList<Condition>();

        Compound(@NotNull Condition condition1, @NotNull Condition condition2) {
            this.conditions.add(condition1);
            this.conditions.add(condition2);
        }

        @Override
        @NotNull
        public Iterator<Condition> iterator() {
            return this.conditions.iterator();
        }
    }

    public static class Not
    implements Condition {
        private final Condition condition;

        public Not(@NotNull Condition condition) {
            this.condition = condition;
        }

        @NotNull
        public Condition getCondition() {
            return this.condition;
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static class Impersonation
    implements Condition {
        private final String name;

        public Impersonation(@NotNull String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Contains
    implements Condition {
        private final String relPath;
        private final String searchExpr;

        public Contains(@NotNull String relPath, @NotNull String searchExpr) {
            this.relPath = relPath;
            this.searchExpr = searchExpr;
        }

        @NotNull
        public String getRelPath() {
            return this.relPath;
        }

        @NotNull
        public String getSearchExpr() {
            return this.searchExpr;
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class PropertyExists
    extends Property {
        PropertyExists(@NotNull String relPath) {
            super(relPath, RelationOp.EX);
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static class PropertyLike
    extends Property {
        private final String pattern;

        PropertyLike(@NotNull String relPath, @NotNull String pattern) {
            super(relPath, RelationOp.LIKE);
            this.pattern = pattern;
        }

        @NotNull
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static class PropertyValue
    extends Property {
        private final Value value;

        PropertyValue(@NotNull String relPath, @NotNull RelationOp op, @NotNull Value value) {
            super(relPath, op);
            this.value = value;
        }

        @NotNull
        public Value getValue() {
            return this.value;
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) throws RepositoryException {
            visitor.visit(this);
        }
    }

    public static abstract class Property
    implements Condition {
        private final String relPath;
        private final RelationOp op;

        private Property(@NotNull String relPath, @NotNull RelationOp op) {
            this.relPath = relPath;
            this.op = op;
        }

        @NotNull
        public String getRelPath() {
            return this.relPath;
        }

        @NotNull
        public RelationOp getOp() {
            return this.op;
        }
    }

    public static class Node
    implements Condition {
        private final String pattern;

        public Node(@NotNull String pattern) {
            this.pattern = pattern;
        }

        @NotNull
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public void accept(@NotNull ConditionVisitor visitor) {
            visitor.visit(this);
        }
    }
}

