/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.SubtreeValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class PrivilegeValidatorProvider
extends ValidatorProvider {
    private final RootProvider rootProvider;
    private final TreeProvider treeProvider;

    PrivilegeValidatorProvider(@NotNull RootProvider rootProvider, @NotNull TreeProvider treeProvider) {
        this.rootProvider = rootProvider;
        this.treeProvider = treeProvider;
    }

    @NotNull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        return new SubtreeValidator((Validator)new PrivilegeValidator(this.createRoot(before), this.createRoot(after), this.treeProvider), new String[]{"jcr:system", "rep:privileges"});
    }

    private Root createRoot(NodeState nodeState) {
        return this.rootProvider.createReadOnlyRoot(nodeState);
    }
}

