/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePattern;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.jetbrains.annotations.Nullable;

public final class ValuePatternUtil {
    @Nullable
    public static String getLongestPrefix(Filter filter, String property) {
        boolean first = false;
        boolean last = false;
        ArrayList<String> list = new ArrayList<String>();
        for (Filter.PropertyRestriction p : filter.getPropertyRestrictions(property)) {
            if (p.isLike) continue;
            if (p.first != null) {
                if (p.first.isArray()) {
                    return null;
                }
                list.add((String)p.first.getValue(Type.STRING));
                first = true;
            }
            if (p.last == null) continue;
            if (p.last.isArray()) {
                return null;
            }
            list.add((String)p.last.getValue(Type.STRING));
            last = true;
        }
        if (!first || !last) {
            return null;
        }
        String prefix = (String)list.get(0);
        for (String s : list) {
            while (!s.startsWith(prefix)) {
                if (!(prefix = prefix.substring(0, prefix.length() - 1)).isEmpty()) continue;
                return null;
            }
        }
        return prefix;
    }

    @Nullable
    public static Set<String> getAllValues(Filter.PropertyRestriction restriction) {
        return ValuePatternUtil.getValues(restriction, ValuePattern.MATCH_ALL);
    }

    @Nullable
    public static Set<String> getValues(Filter.PropertyRestriction restriction, ValuePattern pattern) {
        if (restriction.firstIncluding && restriction.lastIncluding && restriction.first != null && restriction.first.equals(restriction.last)) {
            return ValuePatternUtil.read(restriction.first, pattern);
        }
        if (restriction.list != null) {
            LinkedHashSet values = Sets.newLinkedHashSet();
            for (PropertyValue value : restriction.list) {
                values.addAll(ValuePatternUtil.read(value, pattern));
            }
            return values;
        }
        return null;
    }

    @Nullable
    public static Set<String> read(PropertyValue value, ValuePattern pattern) {
        if (value == null) {
            return null;
        }
        HashSet<String> values = new HashSet<String>();
        for (String v : (Iterable)value.getValue(Type.STRINGS)) {
            if (!pattern.matches(v)) continue;
            values.add(v);
        }
        return values;
    }
}

