/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.jetbrains.annotations.Nullable;

public class FileBlobStore
extends AbstractBlobStore {
    private static final String OLD_SUFFIX = "_old";
    private static final String FILE_SUFFIX = ".dat";
    private final File baseDir;
    private final byte[] buffer = new byte[16384];
    private boolean mark;

    public FileBlobStore(String dir) {
        this.baseDir = new File(dir);
        this.baseDir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeBlob(String tempFilePath) throws IOException {
        MessageDigest messageDigest;
        File file = new File(tempFilePath);
        FileInputStream in = new FileInputStream(file);
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        long length = file.length();
        try (DigestInputStream din = new DigestInputStream(in, messageDigest);){
            int len;
            while ((len = din.read(this.buffer, 0, this.buffer.length)) >= 0) {
            }
        }
        ByteArrayOutputStream idStream = new ByteArrayOutputStream();
        idStream.write(1);
        IOUtils.writeVarInt((OutputStream)idStream, (int)0);
        IOUtils.writeVarLong((OutputStream)idStream, (long)length);
        byte[] digest = messageDigest.digest();
        File f = this.getFile(digest, false);
        if (f.exists()) {
            file.delete();
        } else {
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            file.renameTo(f);
        }
        IOUtils.writeVarInt((OutputStream)idStream, (int)digest.length);
        idStream.write(digest);
        byte[] id = idStream.toByteArray();
        String blobId = StringUtils.convertBytesToHex((byte[])id);
        this.usesBlobId(blobId);
        return blobId;
    }

    @Override
    protected synchronized void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        File f = this.getFile(digest, false);
        if (f.exists()) {
            FileUtils.touch((File)f);
            return;
        }
        File parent = f.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File temp = new File(parent, f.getName() + ".temp");
        FileOutputStream out = new FileOutputStream(temp, false);
        ((OutputStream)out).write(data);
        ((OutputStream)out).close();
        temp.renameTo(f);
    }

    private File getFile(byte[] digest, boolean old) {
        String id = StringUtils.convertBytesToHex((byte[])digest);
        String sub1 = id.substring(id.length() - 2);
        Object sub2 = id.substring(id.length() - 4, id.length() - 2);
        if (old) {
            sub2 = (String)sub2 + OLD_SUFFIX;
        }
        return new File(new File(new File(this.baseDir, sub1), (String)sub2), id + FILE_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId id) throws IOException {
        File f = this.getFile(id.digest, false);
        if (!f.exists()) {
            File old = this.getFile(id.digest, true);
            f.getParentFile().mkdir();
            old.renameTo(f);
            f = this.getFile(id.digest, false);
        }
        int length = (int)Math.min(f.length(), (long)this.getBlockSize());
        byte[] data = new byte[length];
        try (FileInputStream in = new FileInputStream(f);){
            IOUtils.skipFully((InputStream)in, (long)id.pos);
            IOUtils.readFully((InputStream)in, (byte[])data, (int)0, (int)length);
        }
        return data;
    }

    @Override
    public void startMark() throws IOException {
        this.mark = true;
        for (int j = 0; j < 256; ++j) {
            String sub1 = StringUtils.convertBytesToHex((byte[])new byte[]{(byte)j});
            File x = new File(this.baseDir, sub1);
            for (int i = 0; i < 256; ++i) {
                String sub2 = StringUtils.convertBytesToHex((byte[])new byte[]{(byte)i});
                File d = new File(x, sub2);
                File old = new File(x, sub2 + OLD_SUFFIX);
                if (!d.exists()) continue;
                if (old.exists()) {
                    for (File p : d.listFiles()) {
                        String name = p.getName();
                        File newName = new File(old, name);
                        p.renameTo(newName);
                    }
                    continue;
                }
                d.renameTo(old);
            }
        }
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.mark;
    }

    @Override
    protected void mark(AbstractBlobStore.BlockId id) throws IOException {
        File f = this.getFile(id.digest, false);
        if (!f.exists()) {
            File old = this.getFile(id.digest, true);
            f.getParentFile().mkdir();
            old.renameTo(f);
            f = this.getFile(id.digest, false);
        }
    }

    @Override
    public int sweep() throws IOException {
        int count = 0;
        for (int j = 0; j < 256; ++j) {
            String sub1 = StringUtils.convertBytesToHex((byte[])new byte[]{(byte)j});
            File x = new File(this.baseDir, sub1);
            for (int i = 0; i < 256; ++i) {
                String sub = StringUtils.convertBytesToHex((byte[])new byte[]{(byte)i});
                File old = new File(x, sub + OLD_SUFFIX);
                if (!old.exists()) continue;
                for (File p : old.listFiles()) {
                    String name = p.getName();
                    File file = new File(old, name);
                    file.delete();
                    ++count;
                }
                old.delete();
            }
        }
        this.mark = false;
        return count;
    }

    @Override
    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        int count = 0;
        for (String chunkId : chunkIds) {
            byte[] digest = StringUtils.convertHexToBytes((String)chunkId);
            File f = this.getFile(digest, false);
            if (!f.exists()) {
                File old = this.getFile(digest, true);
                f.getParentFile().mkdir();
                old.renameTo(f);
                f = this.getFile(digest, false);
            }
            if (maxLastModifiedTime > 0L && !FileUtils.isFileOlder((File)f, (long)maxLastModifiedTime)) continue;
            f.delete();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> getAllChunkIds(final long maxLastModifiedTime) throws Exception {
        FluentIterable iterable = Files.fileTreeTraverser().postOrderTraversal((Object)this.baseDir);
        final Iterator iter = iterable.filter((Predicate)new Predicate<File>(){

            public boolean apply(@Nullable File input) {
                return !input.isDirectory() && (maxLastModifiedTime <= 0L || FileUtils.isFileOlder((File)input, (long)maxLastModifiedTime));
            }
        }).iterator();
        return new AbstractIterator<String>(){

            protected String computeNext() {
                if (iter.hasNext()) {
                    File file = (File)iter.next();
                    return FilenameUtils.removeExtension((String)file.getName());
                }
                return (String)this.endOfData();
            }
        };
    }

    @Override
    public void clearCache() {
    }
}

