/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool.iotrace;

import java.io.File;
import java.io.Flushable;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.Queues;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.tool.iotrace.IOTraceWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IOTraceMonitor
extends IOMonitorAdapter
implements Flushable {
    @NotNull
    private final AtomicReference<List<String>> context = new AtomicReference<ImmutableList>(ImmutableList.of());
    @NotNull
    private final IOTraceWriter traceWriter;
    @NotNull
    private final Lock ioLock = new ReentrantLock();
    @NotNull
    private final ConcurrentLinkedQueue<IOEvent> ioEvents = Queues.newConcurrentLinkedQueue();

    public IOTraceMonitor(@NotNull IOTraceWriter traceWriter, @Nullable String contextSpec) {
        this.traceWriter = traceWriter;
        traceWriter.writeHeader(IOEvent.getFields(contextSpec));
    }

    public IOTraceMonitor(@NotNull IOTraceWriter traceWriter) {
        this(traceWriter, null);
    }

    public void setContext(@NotNull List<String> context) {
        this.context.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterSegmentRead(@NotNull File file, long msb, long lsb, int length, long elapsed) {
        this.ioEvents.add(new IOEvent(file.getName(), msb, lsb, length, elapsed, this.context.get()));
        if (this.ioLock.tryLock()) {
            try {
                this.flush();
            }
            finally {
                this.ioLock.unlock();
            }
        }
    }

    @Override
    public void flush() {
        this.ioLock.lock();
        try {
            while (!this.ioEvents.isEmpty()) {
                this.traceWriter.writeEntry(Objects.toString(this.ioEvents.poll()));
            }
            this.traceWriter.flush();
        }
        finally {
            this.ioLock.unlock();
        }
    }

    private static class IOEvent {
        private static final String FIELDS = "timestamp,file,segmentId,length,elapsed";
        @NotNull
        private final String fileName;
        private final long msb;
        private final long lsb;
        private final int length;
        private final long elapsed;
        @NotNull
        private final List<String> context;

        private IOEvent(@NotNull String fileName, long msb, long lsb, int length, long elapsed, @NotNull List<String> context) {
            this.fileName = fileName;
            this.msb = msb;
            this.lsb = lsb;
            this.length = length;
            this.elapsed = elapsed;
            this.context = context;
        }

        public static String getFields(@Nullable String contextSpec) {
            if (contextSpec == null || contextSpec.isEmpty()) {
                return FIELDS;
            }
            return "timestamp,file,segmentId,length,elapsed," + contextSpec;
        }

        public String toString() {
            return System.currentTimeMillis() + "," + this.fileName + "," + new UUID(this.msb, this.lsb) + "," + this.length + "," + this.elapsed + "," + String.join((CharSequence)",", this.context);
        }
    }
}

