/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.websites;

import java.io.File;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.websites.dao.SiteDAO;
import org.silverpeas.core.admin.component.ComponentInstancePreDestruction;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Technical
@Bean
@Named
public class WebSitesInstancePreDestruction
implements ComponentInstancePreDestruction {
    @Transactional
    public void preDestroy(String componentInstanceId) {
        try {
            SiteDAO siteDAO = new SiteDAO(componentInstanceId);
            siteDAO.deleteAllWebSites();
            this.deleteAttachmentsAndImagesDirectory(componentInstanceId);
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private void deleteAttachmentsAndImagesDirectory(String componentId) {
        SettingBundle uploadSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.webSites.settings.webSiteSettings");
        FileFolderManager.deleteFolder((String)(uploadSettings.getString("uploadsPath") + File.separator + componentId));
    }
}

