/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.model;

import java.text.ParseException;
import java.util.Date;
import org.silverpeas.components.questionreply.model.Question;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class QuestionDetail
implements SilverpeasContent {
    private static final long serialVersionUID = -5411923403335541499L;
    public static final String TYPE = "QuestionReply";
    private Question question;
    private String silverObjectId;

    public QuestionDetail(Question question) {
        this.question = question;
    }

    public Question getQuestion() {
        return this.question;
    }

    public void setQuestion(Question question) {
        this.question = question;
    }

    public String getId() {
        return this.question.getPK().getId();
    }

    public String getComponentInstanceId() {
        return this.question.getInstanceId();
    }

    public String getSilverpeasContentId() {
        if (this.silverObjectId == null) {
            ContentManagementEngine contentMgtEngine = ContentManagementEngineProvider.getContentManagementEngine();
            try {
                int objectId = contentMgtEngine.getSilverContentId(this.getId(), this.getComponentInstanceId());
                if (objectId >= 0) {
                    this.silverObjectId = String.valueOf(objectId);
                }
            }
            catch (ContentManagerException ex) {
                SilverLogger.getLogger((Object)this).silent((Throwable)ex);
                this.silverObjectId = null;
            }
        }
        return this.silverObjectId;
    }

    public User getCreator() {
        return User.getById((String)this.question.getCreatorId());
    }

    public Date getCreationDate() {
        Date creationDate = null;
        try {
            creationDate = DateUtil.parse((String)this.question.getCreationDate());
        }
        catch (ParseException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return creationDate;
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public String getTitle() {
        return this.question.getTitle();
    }

    public String getDescription() {
        return this.question.getContent();
    }

    public String getContributionType() {
        return TYPE;
    }
}

