/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.memory;

import java.io.IOException;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.memory.MemoryStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;

public class MemoryStoreRevisions
implements Revisions {
    private RecordId head;

    public void bind(MemoryStore store) throws IOException {
        if (this.head == null) {
            NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
            builder.setChildNode("root", EmptyNodeState.EMPTY_NODE);
            this.head = store.getWriter().writeNode(builder.getNodeState());
            store.getWriter().flush();
        }
    }

    private void checkBound() {
        Preconditions.checkState((this.head != null ? 1 : 0) != 0, (Object)"Revisions not bound to a store");
    }

    @Override
    @NotNull
    public synchronized RecordId getHead() {
        this.checkBound();
        return this.head;
    }

    @Override
    @NotNull
    public RecordId getPersistedHead() {
        return this.getHead();
    }

    @Override
    public synchronized boolean setHead(@NotNull RecordId expected, @NotNull RecordId head, Revisions.Option ... options) {
        this.checkBound();
        if (this.head.equals(expected)) {
            this.head = head;
            return true;
        }
        return false;
    }

    @Override
    public RecordId setHead(@NotNull Function<RecordId, RecordId> newHead, Revisions.Option ... options) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

