/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community;

import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.notification.CommunityEventNotifier;
import org.silverpeas.components.community.repository.CommunityOfUsersRepository;
import org.silverpeas.core.admin.component.ComponentInstancePostConstruction;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.space.SpaceHomePageType;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Bean
@Named
public class CommunityInstancePostConstruction
implements ComponentInstancePostConstruction {
    @Inject
    private Administration admin;
    @Inject
    private CommunityOfUsersRepository repository;
    @Inject
    private CommunityEventNotifier notifier;

    @Transactional
    public void postConstruct(String componentInstanceId) {
        ComponentInst instance = this.getComponentInst(componentInstanceId);
        SpaceInst spaceInst = this.getSpaceInst(instance.getSpaceId());
        CommunityOfUsers community = new CommunityOfUsers(instance.getId(), spaceInst.getId());
        CommunityOfUsers savedCommunity = (CommunityOfUsers)this.repository.save((IdentifiableEntity)community);
        if (!spaceInst.isCommunitySpace()) {
            spaceInst.setFirstPageExtraParam(componentInstanceId);
            spaceInst.setInheritanceBlocked(true);
            spaceInst.setCommunitySpace(true);
            spaceInst.setFirstPageType(SpaceHomePageType.COMPONENT_INST.ordinal());
        }
        spaceInst.setFirstPageExtraParam(componentInstanceId);
        spaceInst.setFirstPageType(SpaceHomePageType.COMPONENT_INST.ordinal());
        this.updateSpaceInst(spaceInst);
        this.notifier.notifyEventOn(ResourceEvent.Type.CREATION, (Serializable[])new CommunityOfUsers[]{savedCommunity});
    }

    private ComponentInst getComponentInst(String instanceId) {
        try {
            return this.admin.getComponentInst(instanceId);
        }
        catch (AdminException e) {
            throw new IllegalStateException("The Community application " + instanceId + " should be created!");
        }
    }

    private SpaceInst getSpaceInst(String spaceId) {
        try {
            return this.admin.getSpaceInstById(spaceId);
        }
        catch (AdminException e) {
            throw new IllegalStateException("The space " + spaceId + " should exist!");
        }
    }

    private void updateSpaceInst(SpaceInst spaceInst) {
        try {
            this.admin.updateSpaceInst(spaceInst);
        }
        catch (AdminException e) {
            throw new SilverpeasRuntimeException(e.getMessage());
        }
    }
}

