/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.repository;

import java.util.List;
import org.silverpeas.components.resourcesmanager.model.Reservation;
import org.silverpeas.components.resourcesmanager.repository.ReservationRepository;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;

@Repository
public class ReservationJpaManager
extends BasicJpaEntityRepository<Reservation>
implements ReservationRepository {
    @Override
    public List<Reservation> findAllReservationsInRange(String instanceId, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservation.findAllReservationsInRange", this.newNamedParameters().add("instanceId", (Object)instanceId).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public List<Reservation> findAllReservationsForUserInRange(String instanceId, Integer userId, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservation.findAllReservationsForUserInRange", this.newNamedParameters().add("instanceId", (Object)instanceId).add("userId", (Object)userId).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public List<Reservation> findAllReservationsForUser(String instanceId, Integer userId) {
        return this.listFromNamedQuery("reservation.findAllReservationsForUser", this.newNamedParameters().add("instanceId", (Object)instanceId).add("userId", (Object)userId));
    }

    @Override
    public List<Reservation> findAllReservationsForValidation(String instanceId, Long managerId, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservation.findAllReservationsForValidation", this.newNamedParameters().add("instanceId", (Object)instanceId).add("managerId", (Object)managerId).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public List<Reservation> findAllReservationsNotRefusedForResourceInRange(Long resourceId, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservation.findAllReservationsNotRefusedForResourceInRange", this.newNamedParameters().add("resourceId", (Object)UniqueLongIdentifier.from((long)resourceId)).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public List<Reservation> findAllReservationsForCategoryInRange(String instanceId, Long categoryId, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservation.findAllReservationsForCategoryInRange", this.newNamedParameters().add("instanceId", (Object)instanceId).add("categoryId", (Object)UniqueLongIdentifier.from((long)categoryId)).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public List<Reservation> findAllReservationsForUserAndCategoryInRange(String instanceId, Integer userId, Long categoryId, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservation.findAllReservationsForUserAndCategoryInRange", this.newNamedParameters().add("instanceId", (Object)instanceId).add("userId", (Object)userId).add("categoryId", (Object)UniqueLongIdentifier.from((long)categoryId)).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public List<Reservation> findAllReservationsForResourceInRange(String instanceId, Long resourceId, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservation.findAllReservationsForResourceInRange", this.newNamedParameters().add("instanceId", (Object)instanceId).add("resourceId", (Object)UniqueLongIdentifier.from((long)resourceId)).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public List<Reservation> findAllReservationsForUserAndResourceInRange(String instanceId, Integer userId, Long resourceId, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservation.findAllReservationsForUserAndResourceInRange", this.newNamedParameters().add("instanceId", (Object)instanceId).add("userId", (Object)userId).add("resourceId", (Object)UniqueLongIdentifier.from((long)resourceId)).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public List<Reservation> findAllReservations(String instanceId) {
        return this.listFromNamedQuery("reservation.findAllReservations", this.newNamedParameters().add("instanceId", (Object)instanceId));
    }
}

