/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.local.localContextRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialContextFactory
implements javax.naming.spi.InitialContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InitialContextFactory.class);

    public Context getInitialContext(Hashtable env) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("InitialContextFactory.getInitialContext()");
        }
        localContextRoot ctx = new localContextRoot(env);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created initial context delegate for local namespace:{}", (Object)ctx);
        }
        return ctx;
    }

    public static class DefaultParser
    implements NameParser {
        static Properties syntax = new Properties();

        @Override
        public Name parse(String name) throws NamingException {
            return new CompoundName(name, syntax);
        }

        static {
            syntax.put("jndi.syntax.direction", "left_to_right");
            syntax.put("jndi.syntax.separator", "/");
            syntax.put("jndi.syntax.ignorecase", "false");
        }
    }
}

