/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.scheduleevent.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.Set;
import org.owasp.encoder.Encode;
import org.silverpeas.components.scheduleevent.notification.AbstractScheduleEventUserNotification;
import org.silverpeas.components.scheduleevent.service.model.beans.Contributor;
import org.silverpeas.components.scheduleevent.service.model.beans.Response;
import org.silverpeas.components.scheduleevent.service.model.beans.ScheduleEvent;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.logging.SilverLogger;

public class ScheduleEventUserCallAgainNotification
extends AbstractScheduleEventUserNotification {
    private final String message;

    public ScheduleEventUserCallAgainNotification(ScheduleEvent resource, String message, UserDetail senderUserDetail) {
        super(resource, senderUserDetail);
        this.message = message;
    }

    protected String getTemplateFileName() {
        return "callagain";
    }

    protected Collection<String> getUserIdsToNotify() {
        Set<Contributor> contributors = ((ScheduleEvent)this.getResource()).getContributors();
        ArrayList<String> userIdsToNotify = new ArrayList<String>(contributors.size());
        for (Contributor contributor : contributors) {
            userIdsToNotify.add(String.valueOf(contributor.getUserId()));
        }
        for (Response response : ((ScheduleEvent)this.getResource()).getResponses()) {
            userIdsToNotify.remove(String.valueOf(response.getUserId()));
        }
        return userIdsToNotify;
    }

    protected void performTemplateData(String language, ScheduleEvent resource, SilverpeasTemplate template) {
        String title;
        try {
            title = this.getBundle(language).getString(this.getBundleSubjectKey());
        }
        catch (MissingResourceException ex) {
            SilverLogger.getLogger((Object)((Object)this)).silent((Throwable)ex);
            title = this.getTitle();
        }
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("eventName", (Object)Encode.forHtml((String)resource.getTitle()));
        template.setAttribute("senderName", (Object)this.getSenderUserDetail().getDisplayedName());
        template.setAttribute("silverpeasURL", (Object)this.getResourceURL(resource));
        template.setAttribute("message", (Object)Encode.forHtml((String)this.message));
    }

    protected void performNotificationResource(String language, ScheduleEvent resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getTitle());
        notificationResourceData.setResourceDescription(resource.getDescription());
    }
}

