/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.indicator.ContributionIndicatorRegistry;
import org.silverpeas.core.contribution.indicator.NewContributionIndicator;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.Pair;

@Service
public class KmeliaContributionIndicatorInitializer
implements Initialization {
    public void init() {
        ContributionIndicatorRegistry.get().addNewContributionIndicator((NewContributionIndicator)new KmeliaNewPublicationIndicator());
    }

    static class KmeliaNewPublicationIndicator
    implements NewContributionIndicator {
        private static final SettingBundle SETTING_BUNDLE = ResourceLocator.getSettingBundle((String)"org.silverpeas.publication.publicationSettings");

        KmeliaNewPublicationIndicator() {
        }

        public Pair<String, String> relatedToComponentAndResourceType() {
            return Pair.of((Object)"kmelia", (Object)"Publication");
        }

        public boolean isNew(Instant lastUpdateInstant) {
            int days = SETTING_BUNDLE.getInteger("publication.new", 0);
            LocalDate threshold = LocalDate.ofInstant(lastUpdateInstant, ZoneId.systemDefault()).plusDays(days);
            LocalDate today = LocalDate.now();
            return today.isBefore(threshold) || today.isEqual(threshold);
        }
    }
}

