/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.model;

import java.util.List;
import javax.inject.Inject;
import org.silverpeas.components.community.repository.CommunityOfUsersRepository;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.space.notification.SpaceProfileInstEvent;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public class MembersGroupRemovalFromRoleListener
extends CDIResourceEventListener<SpaceProfileInstEvent> {
    @Inject
    private Administration admin;
    @Inject
    private CommunityOfUsersRepository repository;

    public void onUpdate(SpaceProfileInstEvent event) {
        SpaceProfileInst spaceProfileBefore = (SpaceProfileInst)event.getTransition().getBefore();
        if (!spaceProfileBefore.getName().equals(SilverpeasRole.READER.getName())) {
            return;
        }
        SpaceProfileInst spaceProfileAfter = (SpaceProfileInst)event.getTransition().getAfter();
        String spaceId = "WA" + spaceProfileBefore.getSpaceFatherId();
        List groupsBefore = spaceProfileBefore.getAllGroups();
        List groupsAfter = spaceProfileAfter.getAllGroups();
        this.repository.getBySpaceId(spaceId).flatMap(communityOfUsers -> communityOfUsers.getCommunitySpace().getMembersGroup().flatMap(g -> groupsBefore.stream().filter(id -> id.equals(g.getId())).filter(id -> !groupsAfter.contains(id)).findFirst())).ifPresent(id -> this.execute(() -> {
            spaceProfileAfter.addGroup(id);
            this.admin.updateSpaceProfileInst(spaceProfileAfter, User.getSystemUser().getId());
        }));
    }

    private void execute(AdminOperation operation) {
        try {
            operation.perform();
        }
        catch (AdminException e) {
            throw new SilverpeasRuntimeException("Unexpected error: " + e.getMessage());
        }
    }

    @FunctionalInterface
    private static interface AdminOperation {
        public void perform() throws AdminException;
    }
}

