/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.notification.user;

import java.util.Collection;
import org.silverpeas.components.community.CommunityComponentSettings;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.notification.user.AbstractCommunityUserNotificationBuilder;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.bundle.LocalizationBundle;

public class MembershipLeaveUserNotificationBuilder
extends AbstractCommunityUserNotificationBuilder {
    private final SpaceProfile spaceProfile = this.getSpaceManagerProfile();
    private User leavingMember;
    private int reason;
    private String message;
    private boolean contactInFuture;

    protected MembershipLeaveUserNotificationBuilder(CommunityOfUsers resource) {
        super(resource);
    }

    public static MembershipLeaveUserNotificationBuilder about(CommunityOfUsers community) {
        return new MembershipLeaveUserNotificationBuilder(community);
    }

    public MembershipLeaveUserNotificationBuilder memberLeavingIs(User leavingMember) {
        this.leavingMember = leavingMember;
        return this;
    }

    public MembershipLeaveUserNotificationBuilder withReason(int reason) {
        this.reason = reason;
        return this;
    }

    public MembershipLeaveUserNotificationBuilder andMessage(String message) {
        this.message = message;
        return this;
    }

    public MembershipLeaveUserNotificationBuilder andContactInFuture(boolean contactInFuture) {
        this.contactInFuture = contactInFuture;
        return this;
    }

    protected String getBundleSubjectKey() {
        return "community.membership.leaving.notif.subject";
    }

    protected String getTemplateFileName() {
        return "communityMembershipLeaving";
    }

    protected String getTitle(String language) {
        return this.getBundle(language).getStringWithParams(this.getBundleSubjectKey(), new Object[]{this.getSpace().getName(language)});
    }

    protected Collection<String> getUserIdsToNotify() {
        return this.spaceProfile.getAllUserIds();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return this.spaceProfile.getAllGroupIds();
    }

    @Override
    protected String getSender() {
        return this.leavingMember.getId();
    }

    protected void perform(CommunityOfUsers resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().setOriginalExtraMessage(this.message);
    }

    @Override
    protected void performTemplateData(String language, CommunityOfUsers resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("reason", (Object)CommunityComponentSettings.getLeaveReasons(language).get(this.reason));
        template.setAttribute("memberFullName", (Object)this.leavingMember.getDisplayedName());
        LocalizationBundle bundle = this.getBundle(language);
        template.setAttribute("contactInFuture", (Object)(this.contactInFuture ? bundle.getString("GML.yes") : bundle.getString("GML.no")));
    }
}

