/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community;

import java.io.Serializable;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.notification.CommunityEventNotifier;
import org.silverpeas.components.community.repository.CommunityMembershipRepository;
import org.silverpeas.components.community.repository.CommunityOfUsersRepository;
import org.silverpeas.core.admin.component.ComponentInstancePreDestruction;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Named
public class CommunityInstancePreDestruction
implements ComponentInstancePreDestruction {
    @Inject
    private CommunityOfUsersRepository communitiesRepository;
    @Inject
    private CommunityMembershipRepository membersRepository;
    @Inject
    private CommunityEventNotifier notifier;

    @Transactional
    public void preDestroy(String componentInstanceId) {
        this.communitiesRepository.getByComponentInstanceId(componentInstanceId).ifPresent(c -> {
            Optional.ofNullable(c.getSpacePresentationContent()).map(WysiwygContent::getContribution).ifPresent(WysiwygContent::deleteAllContents);
            this.membersRepository.getMembershipsTable((CommunityOfUsers)((Object)c)).deleteAll();
            c.delete();
            this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, (Serializable[])new CommunityOfUsers[]{c});
        });
    }
}

