/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.FastDateFormat;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.kernel.util.Pair;

public class PostDAO {
    private static final FastDateFormat FORMATTER = FastDateFormat.getInstance((String)"yyyy/MM/dd");
    private static final String BLOG_POST_TABLE_NAME = "SC_Blog_Post";
    private static final String PUB_ID = "pubId";
    private static final String DATE_EVENT = "dateEvent";
    private static final String EVENT_PERIOD_CLAUSE = "dateEvent >= ? and dateEvent <= ?";
    private static final String INSTANCE_ID_CLAUSE = "instanceId = ?";
    private static final String DESC = " DESC";
    private static final String ORDER_BY_DATE = "dateEvent DESC";
    private static final String[] ORDER_BY_DATE_AND_PUB_ID = new String[]{"dateEvent DESC", "pubId DESC"};

    private PostDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(Connection con, String pubId, Date dateEvent, String instanceId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "insert into SC_Blog_Post (pubId, dateEvent, instanceId) values (?, ?, ?)";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(pubId));
            prepStmt.setString(2, Long.toString(dateEvent.getTime()));
            prepStmt.setString(3, instanceId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static Map<String, Date> getEventDateIndexedByPost(Collection<String> pubIds) throws SQLException {
        return JdbcSqlQuery.streamBySplittingOn(pubIds, idBatch -> JdbcSqlQuery.select((String)"pubId, dateEvent").from(new String[]{BLOG_POST_TABLE_NAME}).where(PUB_ID, new Object[0]).in((Collection)idBatch.stream().map(Integer::parseInt).collect(Collectors.toList())).execute(r -> Pair.of((Object)r.getString(1), (Object)new Date(Long.parseLong(r.getString(2)))))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Connection con, String pubId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "delete from SC_Blog_Post where pubId = ? ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(pubId));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Connection con, String pubId, Date dateEvent) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "update SC_Blog_Post set dateEvent = ? where pubId = ?";
            prepStmt = con.prepareStatement(query);
            prepStmt.setString(1, "" + dateEvent.getTime());
            prepStmt.setInt(2, Integer.parseInt(pubId));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static Collection<String> getAllPostIds(Connection con, String instanceId) throws SQLException {
        return JdbcSqlQuery.select((String)PUB_ID).from(new String[]{BLOG_POST_TABLE_NAME}).where(INSTANCE_ID_CLAUSE, new Object[]{instanceId}).orderBy(ORDER_BY_DATE_AND_PUB_ID).executeWith(con, r -> String.valueOf(r.getInt(PUB_ID)));
    }

    public static Collection<Date> getAllEventDates(Connection con, String instanceId) throws SQLException {
        return JdbcSqlQuery.select((String)"DISTINCT dateEvent").from(new String[]{BLOG_POST_TABLE_NAME}).where(INSTANCE_ID_CLAUSE, new Object[]{instanceId}).orderBy(new String[]{ORDER_BY_DATE}).executeWith(con, r -> new Date(Long.parseLong(r.getString(DATE_EVENT))));
    }

    public static Collection<String> getPostInRange(Connection con, String instanceId, String beginDate, String endDate) throws SQLException, ParseException {
        return JdbcSqlQuery.select((String)PUB_ID).from(new String[]{BLOG_POST_TABLE_NAME}).where(INSTANCE_ID_CLAUSE, new Object[]{instanceId}).and(EVENT_PERIOD_CLAUSE, new Object[]{Long.toString(FORMATTER.parse(beginDate).getTime()), Long.toString(FORMATTER.parse(endDate).getTime())}).orderBy(ORDER_BY_DATE_AND_PUB_ID).executeWith(con, r -> String.valueOf(r.getInt(PUB_ID)));
    }
}

