/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.lang.ref.ReferenceQueue;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnmergedBranches {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<Branch> branches = new CopyOnWriteArrayList<Branch>();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    UnmergedBranches() {
    }

    void init(DocumentStore store, RevisionContext context, int batchSize) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("already initialized");
        }
        this.purgeUnmergedBranchCommitAndCollisionMarkers(store, context.getClusterId(), batchSize, c -> true);
    }

    void purgeUnmergedBranchCommitAndCollisionMarkers(DocumentStore store, int clusterId, int batchSize, Predicate<Revision> olderThanLastWrittenRootRevPredicate) {
        NodeDocument doc = store.find(Collection.NODES, Utils.getIdFromPath(Path.ROOT));
        if (doc == null) {
            return;
        }
        int purgeCount = doc.purgeUncommittedRevisions(clusterId, batchSize, olderThanLastWrittenRootRevPredicate);
        if (purgeCount > 0) {
            this.log.info("Purged [{}] uncommitted branch revision entries", (Object)purgeCount);
        }
        if ((purgeCount = doc.purgeCollisionMarkers(clusterId, batchSize, olderThanLastWrittenRootRevPredicate)) > 0) {
            this.log.info("Purged [{}] collision markers", (Object)purgeCount);
        }
    }

    @NotNull
    Branch create(@NotNull RevisionVector base, @NotNull Revision initial, @Nullable Object guard) {
        Preconditions.checkArgument((!((RevisionVector)Preconditions.checkNotNull((Object)base)).isBranch() ? 1 : 0) != 0, (String)"base is not a trunk revision: %s", (Object)base);
        Preconditions.checkArgument((boolean)((Revision)Preconditions.checkNotNull((Object)initial)).isBranch(), (String)"initial is not a branch revision: %s", (Object)initial);
        TreeSet<Revision> commits = new TreeSet<Revision>(StableRevisionComparator.INSTANCE);
        commits.add(initial);
        Branch b = new Branch(commits, base, this.queue, guard);
        this.branches.add(b);
        return b;
    }

    @Nullable
    Branch getBranch(@NotNull RevisionVector r) {
        if (!r.isBranch()) {
            return null;
        }
        Revision branchRev = r.getBranchRevision();
        for (Branch b : this.branches) {
            if (!b.containsCommit(branchRev)) continue;
            return b;
        }
        return null;
    }

    boolean isBranchBase(@NotNull RevisionVector r) {
        if (!r.isBranch()) {
            return false;
        }
        RevisionVector base = r.asTrunkRevision();
        for (Branch b : this.branches) {
            if (!b.getBase().equals(base)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    Branch.BranchCommit getBranchCommit(@NotNull Revision r) {
        for (Branch b : this.branches) {
            Branch.BranchCommit c = b.getCommit(r);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    void remove(Branch b) {
        this.branches.remove(b);
    }

    int size() {
        return this.branches.size();
    }

    Branch pollOrphanedBranch() {
        Branch.BranchReference ref = (Branch.BranchReference)this.queue.poll();
        if (ref != null && this.branches.remove(ref.getBranch())) {
            return ref.getBranch();
        }
        return null;
    }
}

