/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.CRC32;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.util.ReaderAtEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphLoader {
    private static final Logger log = LoggerFactory.getLogger(GraphLoader.class);
    private static final int FOOTER_SIZE = 16;

    private GraphLoader() {
    }

    public static Buffer loadGraph(ReaderAtEnd readerAtEnd) throws IOException {
        Buffer meta = readerAtEnd.readAtEnd(16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170936074) {
            log.warn("Invalid graph magic number");
            return null;
        }
        if (count < 0) {
            log.warn("Invalid number of entries");
            return null;
        }
        if (bytes < 4 + count * 34) {
            log.warn("Invalid entry size");
            return null;
        }
        Buffer graph = readerAtEnd.readAtEnd(bytes, bytes);
        byte[] b = new byte[bytes - 16];
        graph.mark();
        graph.get(b);
        graph.reset();
        CRC32 checksum = new CRC32();
        checksum.update(b);
        if (crc32 != (int)checksum.getValue()) {
            log.warn("Invalid graph checksum in tar file");
            return null;
        }
        return graph;
    }

    public static Map<UUID, List<UUID>> parseGraph(Buffer buffer) {
        int nEntries = buffer.getInt(buffer.limit() - 12);
        HashMap graph = Maps.newHashMapWithExpectedSize((int)nEntries);
        for (int i = 0; i < nEntries; ++i) {
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            int nVertices = buffer.getInt();
            ArrayList vertices = Lists.newArrayListWithCapacity((int)nVertices);
            for (int j = 0; j < nVertices; ++j) {
                long vMsb = buffer.getLong();
                long vLsb = buffer.getLong();
                vertices.add(new UUID(vMsb, vLsb));
            }
            graph.put(new UUID(msb, lsb), vertices);
        }
        return graph;
    }
}

