/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import java.util.Map;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheActionDispatcher;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.InvalidateCacheAction;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.PutToCacheAction;

public class CacheWriteQueue<K extends CacheValue, V extends CacheValue> {
    private final CacheActionDispatcher dispatcher;
    private final PersistentCache cache;
    private final Map<K, V> map;

    public CacheWriteQueue(CacheActionDispatcher dispatcher, PersistentCache cache, Map<K, V> map) {
        this.dispatcher = dispatcher;
        this.cache = cache;
        this.map = map;
    }

    public boolean addPut(K key, V value) {
        return this.dispatcher.add(new PutToCacheAction<K, V>(key, value, this));
    }

    public boolean addInvalidate(Iterable<K> keys) {
        return this.dispatcher.add(new InvalidateCacheAction(keys, this));
    }

    PersistentCache getCache() {
        return this.cache;
    }

    Map<K, V> getMap() {
        return this.map;
    }
}

