/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ShutDown {
    private volatile boolean isShutDown;
    private boolean shutDown;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    ShutDown() {
    }

    ShutDownCloser keepAlive() {
        this.lock.readLock().lock();
        if (this.shutDown) {
            this.lock.readLock().unlock();
            throw new IllegalStateException("already shut down");
        }
        return () -> this.lock.readLock().unlock();
    }

    ShutDownCloser tryKeepAlive() {
        this.lock.readLock().lock();
        return () -> this.lock.readLock().unlock();
    }

    ShutDownCloser shutDown() {
        this.isShutDown = true;
        this.lock.writeLock().lock();
        if (this.shutDown) {
            this.lock.writeLock().unlock();
            throw new IllegalStateException("already shut down");
        }
        return () -> {
            this.shutDown = true;
            this.lock.writeLock().unlock();
        };
    }

    boolean isShutDown() {
        return this.isShutDown;
    }

    static interface ShutDownCloser
    extends AutoCloseable {
        @Override
        public void close();
    }
}

