/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.IntTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class FastTaxonomyFacetCounts
extends IntTaxonomyFacets {
    public FastTaxonomyFacetCounts(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        this("$facets", taxoReader, config, fc);
    }

    public FastTaxonomyFacetCounts(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.count(fc.getMatchingDocs());
    }

    public FastTaxonomyFacetCounts(String indexFieldName, IndexReader reader, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.countAll(reader);
    }

    private final void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            BinaryDocValues dv = hits.context.reader().getBinaryDocValues(this.indexFieldName);
            if (dv == null) continue;
            DocIdSetIterator it = ConjunctionDISI.intersectIterators(Arrays.asList(hits.bits.iterator(), dv));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef bytesRef = dv.binaryValue();
                byte[] bytes = bytesRef.bytes;
                int end = bytesRef.offset + bytesRef.length;
                int ord = 0;
                int offset = bytesRef.offset;
                int prev = 0;
                while (offset < end) {
                    byte b;
                    if ((b = bytes[offset++]) >= 0) {
                        prev = ord = (ord << 7 | b) + prev;
                        int n = ord;
                        this.values[n] = this.values[n] + 1;
                        ord = 0;
                        continue;
                    }
                    ord = ord << 7 | b & 0x7F;
                }
                doc = it.nextDoc();
            }
        }
        this.rollup();
    }

    private final void countAll(IndexReader reader) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            BinaryDocValues dv = context.reader().getBinaryDocValues(this.indexFieldName);
            if (dv == null) continue;
            Bits liveDocs = context.reader().getLiveDocs();
            int doc = dv.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    BytesRef bytesRef = dv.binaryValue();
                    byte[] bytes = bytesRef.bytes;
                    int end = bytesRef.offset + bytesRef.length;
                    int ord = 0;
                    int offset = bytesRef.offset;
                    int prev = 0;
                    while (offset < end) {
                        byte b;
                        if ((b = bytes[offset++]) >= 0) {
                            prev = ord = (ord << 7 | b) + prev;
                            int n = ord;
                            this.values[n] = this.values[n] + 1;
                            ord = 0;
                            continue;
                        }
                        ord = ord << 7 | b & 0x7F;
                    }
                }
                doc = dv.nextDoc();
            }
        }
        this.rollup();
    }
}

