/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.exceptions;

import edu.psu.swe.commons.jaxrs.ErrorMessage;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;

public class ConflictingDataException
extends Exception {
    private static final long serialVersionUID = 7360783673606191576L;
    private int statusCode;
    private ErrorMessage errorMessage;

    public ConflictingDataException(Response response) {
        this.statusCode = response.getStatus();
        try {
            this.errorMessage = (ErrorMessage)response.readEntity(ErrorMessage.class);
        }
        catch (ProcessingException e) {
            this.errorMessage = null;
        }
    }

    public ConflictingDataException(int statusCode, ErrorMessage errorMessage) {
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ErrorMessage getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getMessage() {
        String message = "Rest Client Exception: Status Code: " + this.statusCode + " ";
        if (this.errorMessage != null) {
            message = message + "Error Messages: " + this.errorMessage.getErrorMessageList();
        }
        return message;
    }
}

