/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.compress;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;

public final class LowercaseAsciiCompression {
    private static final boolean isCompressible(int b) {
        int high3Bits = b + 1 & 0xFFFFFFE0;
        return high3Bits == 32 || high3Bits == 96;
    }

    private LowercaseAsciiCompression() {
    }

    public static boolean compress(byte[] in, int len, byte[] tmp, DataOutput out) throws IOException {
        int i;
        if (len < 8) {
            return false;
        }
        int maxExceptions = len >>> 5;
        int previousExceptionIndex = 0;
        int numExceptions = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int b = in[i2] & 0xFF;
            if (LowercaseAsciiCompression.isCompressible(b)) continue;
            while (i2 - previousExceptionIndex > 255) {
                ++numExceptions;
                previousExceptionIndex += 255;
            }
            if (++numExceptions > maxExceptions) {
                return false;
            }
            previousExceptionIndex = i2;
        }
        assert (numExceptions <= maxExceptions);
        int compressedLen = len - (len >>> 2);
        assert (compressedLen < len);
        for (int i3 = 0; i3 < len; ++i3) {
            int b = (in[i3] & 0xFF) + 1;
            tmp[i3] = (byte)(b & 0x1F | (b & 0x40) >>> 1);
        }
        int o = 0;
        for (i = compressedLen; i < len; ++i) {
            int n = o++;
            tmp[n] = (byte)(tmp[n] | (tmp[i] & 0x30) << 2);
        }
        for (i = compressedLen; i < len; ++i) {
            int n = o++;
            tmp[n] = (byte)(tmp[n] | (tmp[i] & 0xC) << 4);
        }
        for (i = compressedLen; i < len; ++i) {
            int n = o++;
            tmp[n] = (byte)(tmp[n] | (tmp[i] & 3) << 6);
        }
        assert (o <= compressedLen);
        out.writeBytes(tmp, 0, compressedLen);
        out.writeVInt(numExceptions);
        if (numExceptions > 0) {
            previousExceptionIndex = 0;
            int numExceptions2 = 0;
            for (int i4 = 0; i4 < len; ++i4) {
                int b = in[i4] & 0xFF;
                if (LowercaseAsciiCompression.isCompressible(b)) continue;
                while (i4 - previousExceptionIndex > 255) {
                    out.writeByte((byte)-1);
                    out.writeByte(in[previousExceptionIndex += 255]);
                    ++numExceptions2;
                }
                out.writeByte((byte)(i4 - previousExceptionIndex));
                previousExceptionIndex = i4;
                out.writeByte((byte)b);
                ++numExceptions2;
            }
            if (numExceptions != numExceptions2) {
                throw new IllegalStateException(numExceptions + " <> " + numExceptions2 + " " + new BytesRef(in, 0, len));
            }
        }
        return true;
    }

    public static void decompress(DataInput in, byte[] out, int len) throws IOException {
        int i;
        int saved = len >>> 2;
        int compressedLen = len - saved;
        in.readBytes(out, 0, compressedLen);
        for (i = 0; i < saved; ++i) {
            out[compressedLen + i] = (byte)((out[i] & 0xC0) >>> 2 | (out[saved + i] & 0xC0) >>> 4 | (out[(saved << 1) + i] & 0xC0) >>> 6);
        }
        for (i = 0; i < len; ++i) {
            byte b = out[i];
            out[i] = (byte)((b & 0x1F | 0x20 | (b & 0x20) << 1) - 1);
        }
        int numExceptions = in.readVInt();
        int i2 = 0;
        for (int exception = 0; exception < numExceptions; ++exception) {
            out[i2 += in.readByte() & 0xFF] = in.readByte();
        }
    }
}

