/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process.media;

import org.apache.commons.fileupload.FileItem;
import org.silverpeas.components.gallery.MediaUtil;
import org.silverpeas.components.gallery.Watermark;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.process.AbstractGalleryFileProcess;
import org.silverpeas.core.process.io.file.FileHandler;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class GalleryUpdateMediaFileProcess
extends AbstractGalleryFileProcess {
    private final FileItem fileItem;
    private final Watermark watermark;

    public static GalleryUpdateMediaFileProcess getInstance(Media media, FileItem fileItem, Watermark watermark) {
        return new GalleryUpdateMediaFileProcess(media, fileItem, watermark);
    }

    protected GalleryUpdateMediaFileProcess(Media media, FileItem fileItem, Watermark watermark) {
        super(media);
        this.fileItem = fileItem;
        this.watermark = watermark;
    }

    public void processFiles(ProcessExecutionContext context, ProcessSession session, FileHandler fileHandler) throws Exception {
        String name;
        boolean hasBeenProcessed = false;
        if (this.fileItem != null && !this.getMedia().getType().isStreaming() && StringUtil.isDefined((String)(name = this.fileItem.getName()))) {
            hasBeenProcessed = true;
            fileHandler.getHandledFile(Media.BASE_PATH, new String[]{context.getComponentInstanceId(), this.getMedia().getWorkspaceSubFolderName()}).delete();
            switch (this.getMedia().getType()) {
                case Photo: {
                    MediaUtil.processPhoto(fileHandler, this.getMedia().getPhoto(), this.fileItem, this.watermark);
                    break;
                }
                case Video: {
                    MediaUtil.processVideo(fileHandler, this.getMedia().getVideo(), this.fileItem);
                    break;
                }
                case Sound: {
                    MediaUtil.processSound(fileHandler, this.getMedia().getSound(), this.fileItem);
                    break;
                }
            }
        }
        if (!this.getMedia().getType().isStreaming() && !hasBeenProcessed) {
            SilverLogger.getLogger((Object)((Object)this)).warn(this.getMedia().getType().name() + " media type is never processed", new Object[0]);
        }
    }
}

