/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.datatypes;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.shared.JenaException;

public class DatatypeFormatException
extends JenaException {
    private final String lexicalForm;
    private final RDFDatatype dataType;

    public DatatypeFormatException(String lexicalForm, RDFDatatype dtype, String msg) {
        super("Lexical form '" + lexicalForm + "' is not a legal instance of " + dtype + " " + msg);
        this.lexicalForm = lexicalForm;
        this.dataType = dtype;
    }

    public DatatypeFormatException() {
        this.lexicalForm = null;
        this.dataType = null;
    }

    public DatatypeFormatException(String msg) {
        super(msg);
        this.lexicalForm = null;
        this.dataType = null;
    }

    public String getLexicalForm() {
        return this.lexicalForm;
    }

    public RDFDatatype getDataType() {
        return this.dataType;
    }
}

